/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.identification.login;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaCreateReq;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaCreateResp;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaVerificationReq;
import com.cusc.nirvana.user.auth.identification.service.ICaptchaService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/captcha"})
public class CaptchaController {
    private static final Logger log = LoggerFactory.getLogger(CaptchaController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptchaController.class);
    @Autowired
    private ICaptchaService captchaService;

    @PostMapping(value={"/simpleGraphic"})
    @ApiOperation(value="\u7b80\u5355\u56fe\u5f62\u9a8c\u8bc1\u7801", notes="\u7b80\u5355\u56fe\u5f62\u9a8c\u8bc1\u7801")
    public Response<CaptchaCreateResp> simpleGraphic(@RequestBody CaptchaCreateReq captchaReq) {
        if (captchaReq == null || captchaReq.getCaptchaType() == null || captchaReq.getCaptchaHeight() == 0 || captchaReq.getCaptchaWidth() == 0 || captchaReq.getCaptchaLength() == 0 || CuscStringUtils.isEmpty((String)captchaReq.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.captchaService.generateCaptcha(captchaReq));
    }

    @PostMapping(value={"/verificationCaptcha"})
    @ApiOperation(value="\u9a8c\u8bc1\u56fe\u5f62\u9a8c\u8bc1\u7801", notes="\u9a8c\u8bc1\u56fe\u5f62\u9a8c\u8bc1\u7801")
    public Response verificationCaptcha(@RequestBody CaptchaVerificationReq bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getCaptchaValue()) || CuscStringUtils.isEmpty((String)bean.getRequestId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.captchaService.verificationCaptcha(bean));
    }
}

