package com.cusc.nirvana.user.eiam.util;

import org.apache.commons.lang3.StringUtils;

/**
 * Description: 智网sql工具类
 * <br />
 * CreateDate 2022-07-08 20:31:36
 *
 * @author yuyi
 **/
public class CuscSqlUtils {

    private final static String[] keywords =
            {"'", "\"", ";", "\\", "*", "-", "+", "%", "master", "truncate", "insert", "select", "delete", "update",
                    "declare",
                    "alert", "drop", "and", "exec", "execute", "count", "xp_cmdshell", "declare", "sitename", "mid", "union", "from"};

    /**
     * Description: 转换sql注入
     * <br />
     * CreateDate 2022-07-08 20:32:05
     *
     * @author yuyi
     **/
    public static String transactSQLInjection(String str) {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        //判断是否包含非法字符
        for (String keyword : keywords) {
            if (str.indexOf(keyword) != -1) {
                str = StringUtils.replace(str, keyword, "");
            }
        }

        return str;
    }
}
