package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.converter.UserResourceConverter;
import com.cusc.nirvana.user.eiam.dao.UserResourceDao;
import com.cusc.nirvana.user.eiam.dao.entity.UserResourcePO;
import com.cusc.nirvana.user.eiam.dto.UserResourceDTO;
import com.cusc.nirvana.user.eiam.service.IUserResourceService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 用户资源关系(UserResource)表服务实现类
 *
 * @author yuy336
 * @since 2022-01-19 13:41:03
 */
@Service
public class UserResourceServiceImpl extends ServiceImpl<UserResourceDao, UserResourcePO>
        implements IUserResourceService {

    /**
     * 通过查询条件查询集合数据
     *
     * @param bean
     * @return 集合对象
     */
    @Override
    public List<UserResourceDTO> queryByList(UserResourceDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc("create_time");
        List<UserResourcePO> record = this.list(queryWrapper);
        return UserResourceConverter.INSTANCE.poListToDtoList(record);
    }

    /**
     * 新增数据
     *
     * @param bean 实例对象
     * @return 实例对象
     */
    @Override
    @Transactional
    public UserResourceDTO insert(UserResourceDTO bean) {
        UserResourcePO userResourcePO = UserResourceConverter.INSTANCE.dtoToPo(bean);
        this.save(userResourcePO);
        return bean;
    }

    @Override
    @Transactional
    public Integer insertBatchResource(UserResourceDTO bean) {
        //先删除
        bean.setOperator(bean.getCreator());
        deleteByUserId(bean);
        List<UserResourcePO> urList = new ArrayList<>();
        if(!CollectionUtils.isEmpty(bean.getResourceIdList())){
            UserResourcePO urDO;
            for (String resourceId : bean.getResourceIdList()) {
                urDO = new UserResourcePO();
                urDO.setUserId(bean.getUserId());
                urDO.setResourceId(resourceId);
                urDO.setTenantNo(bean.getTenantNo());
                urDO.setApplicationId(bean.getApplicationId());
                urList.add(urDO);
            }
            //新增
            this.saveBatch(urList);
        }
        return urList.size();
    }

    @Override
    @Transactional
    public boolean deleteByUserId(UserResourceDTO bean) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq("user_id", bean.getUserId());
        updateWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        updateWrapper.eq("tenant_no", bean.getTenantNo());
        updateWrapper.eq(CuscStringUtils.isNotEmpty(bean.getApplicationId()), "application_id",
                bean.getApplicationId());

        UserResourcePO urDO = new UserResourcePO();
        urDO.setIsDelete(CommonDeleteEnum.DELETED.getCode());
        urDO.setOperator(bean.getOperator());
        this.update(urDO, updateWrapper);
        return false;
    }
}
