package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.converter.UserOrganConverter;
import com.cusc.nirvana.user.eiam.dao.UserOrganDao;
import com.cusc.nirvana.user.eiam.dao.entity.UserOrganPO;
import com.cusc.nirvana.user.eiam.dto.UserOrganDTO;
import com.cusc.nirvana.user.eiam.service.IUserOrganService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 用户组织信息(UserOrgan)表服务实现类
 *
 * @author yuy336
 * @since 2022-01-12 15:00:02
 */
@Service
public class UserOrganServiceImpl extends ServiceImpl<UserOrganDao, UserOrganPO> implements IUserOrganService {

    /**
     * 通过UUID查询单条数据
     *
     * @param userOrgan
     * @return 实例对象
     */
    @Override
    public UserOrganDTO getByUuid(UserOrganDTO userOrgan) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("uuid", userOrgan.getUuid());
        queryWrapper.eq("is_delete", 0);
        UserOrganPO record = this.getOne(queryWrapper);
        return UserOrganConverter.INSTANCE.poToDto(record);
    }
    
     /**
     * 通过查询条件查询集合数据
     *
     * @param userOrgan
     * @return 集合对象
     */
    @Override
    public List<UserOrganDTO> queryByList(UserOrganDTO userOrgan) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc("create_time");

        queryWrapper.eq(StringUtils.isNotBlank(userOrgan.getTenantNo()),"tenant_no", userOrgan.getTenantNo());
        if (!CollectionUtils.isEmpty(userOrgan.getOrganIdList())) {
			queryWrapper.in("organ_id",userOrgan.getOrganIdList());
		}
		queryWrapper.eq(CuscStringUtils.isNotEmpty(userOrgan.getUserId()),"user_id",userOrgan.getUserId());
		queryWrapper.eq(CuscStringUtils.isNotEmpty(userOrgan.getOrganId()),"organ_id",userOrgan.getOrganId());
        List<UserOrganPO> record = this.list(queryWrapper);
        return UserOrganConverter.INSTANCE.poListToDtoList(record);
    }

    /**
     * 分页查询
     *
     * @param userOrgan 筛选条件
     * @return 查询结果
     */
    @Override
    public PageResult<UserOrganDTO> queryByPage(UserOrganDTO userOrgan) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc("create_time");
        queryWrapper.eq("is_delete", 0);
        
       Page<UserOrganPO> page =
                this.page(new Page<>(userOrgan.getCurrPage(), userOrgan.getPageSize()), queryWrapper);
        return PageHelper.convert(page, UserOrganDTO.class);
    }

    /**
     * 新增数据
     *
     * @param userOrgan 实例对象
     * @return 实例对象
     */
    @Override
    @Transactional
    public UserOrganDTO insert(UserOrganDTO userOrgan) {
       UserOrganPO userOrganPO = UserOrganConverter.INSTANCE.dtoToPo(userOrgan);
        this.save(userOrganPO);
        return userOrgan;
    }

    /**
     * 修改数据
     *
     * @param userOrgan 实例对象
     * @return 实例对象
     */
    @Override
    @Transactional
    public UserOrganDTO update(UserOrganDTO userOrgan) {
        UserOrganPO userOrganPO = this.getPoByUuid(userOrgan.getUuid());
        this.updateById(userOrganPO);
        return userOrgan;
    }

    /**
     * 通过主键删除数据
     * @param userOrgan 实例对象
     * @return 是否成功
     */
    @Override
    @Transactional
    public boolean deleteById(UserOrganDTO userOrgan) {
        UserOrganPO userOrganPO = this.getPoByUuid(userOrgan.getUuid());
        return this.updateById(userOrganPO);
    }
    
    /**
     * 通过UUID查询单条数据
     *
     * @param uuid
     * @return 实例对象
     */
    private UserOrganPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("uuid", uuid);
        queryWrapper.eq("is_delete", 0);
        return this.getOne(queryWrapper);
    }
}
