package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.constants.CommonStatusEnum;
import com.cusc.nirvana.user.eiam.constants.CommonYesOrNoEnum;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.converter.RoleConverter;
import com.cusc.nirvana.user.eiam.dao.RoleDao;
import com.cusc.nirvana.user.eiam.dao.entity.RolePO;
import com.cusc.nirvana.user.eiam.dao.entity.UserPO;
import com.cusc.nirvana.user.eiam.dto.RoleDTO;
import com.cusc.nirvana.user.eiam.dto.RoleResourceDTO;
import com.cusc.nirvana.user.eiam.dto.RoleSimpleDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.service.IRoleResourceService;
import com.cusc.nirvana.user.eiam.service.IRoleService;
import com.cusc.nirvana.user.eiam.util.CuscSqlUtils;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author auto-generator
 * @since 2021-10-20
 */
@Service
public class RoleServiceImpl extends ServiceImpl<RoleDao, RolePO> implements IRoleService {

    @Autowired
    private IRoleResourceService roleResourceService;

    @Override
    @Transactional
    public RoleDTO add(RoleDTO entity) {
        RolePO entity0 = new RolePO();
        BeanUtils.copyProperties(entity, entity0);
        String roleUuid = CuscStringUtils.generateUuid();
        entity0.setUuid(roleUuid);
        if (CuscStringUtils.isEmpty(entity0.getParentId())) {
            entity0.setParentId("0");
        }

        RoleDTO checkRole = new RoleDTO();
        checkRole.setRoleName(entity.getRoleName());
        List<RoleSimpleDTO> checkRoleList = queryRoleByParams(checkRole);
        if (!CollectionUtils.isEmpty(checkRoleList)) {
            throw new CuscUserException(ResponseCode.ROLE_NAME_REPEAT.getCode(),
                    ResponseCode.ROLE_NAME_REPEAT.getMsg());
        }
        //新增角色
        this.save(entity0);
        entity.setUuid(entity0.getUuid());

        if (!CollectionUtils.isEmpty(entity.getResourceUuidList())) {
            //保存角色与资源的关系
            RoleResourceDTO rrDTO = new RoleResourceDTO();
            rrDTO.setResourceUuidList(entity.getResourceUuidList());
            rrDTO.setRoleId(roleUuid);
            rrDTO.setTenantNo(entity.getTenantNo());
            rrDTO.setApplicationId(entity.getApplicationId());
            rrDTO.setCreator(entity.getCreator());
            roleResourceService.addBatchResource(rrDTO);
        }
        return entity;
    }

    @Override
    @Transactional
    public RoleDTO update(RoleDTO entity) {
        RolePO entity0 = this.getPoByUuid(entity.getUuid(), entity.getTenantNo());
        if (entity0 == null || CommonDeleteEnum.DELETED.getCode() == entity0.getIsDelete()) {
            throw new CuscUserException(ResponseCode.ROLE_INVALID.getCode(),
                    ResponseCode.ROLE_INVALID.getMsg());
        }
        entity.setId(entity0.getId());
        entity.setRoleScene(entity0.getRoleScene());
        //检查角色名称是否重复
        if(CuscStringUtils.isNotEmpty(entity.getRoleName())){
            RoleDTO checkRole = new RoleDTO();
            checkRole.setRoleName(entity.getRoleName());
            checkRole.setId(entity0.getId());
            checkRole.setTenantNo(entity.getTenantNo());
            checkRole.setApplicationId(entity.getApplicationId());
            List<RoleSimpleDTO> checkRoleList = queryRoleByParams(checkRole);
            if (!CollectionUtils.isEmpty(checkRoleList)) {
                throw new CuscUserException(ResponseCode.ROLE_NAME_REPEAT.getCode(),
                        ResponseCode.ROLE_NAME_REPEAT.getMsg());
            }
        }

        //编辑角色与资源的关系
        if(!CollectionUtils.isEmpty(entity.getResourceUuidList())){
            RoleResourceDTO rrDTO = new RoleResourceDTO();
            rrDTO.setResourceUuidList(entity.getResourceUuidList());
            rrDTO.setRoleId(entity.getUuid());
            rrDTO.setTenantNo(entity.getTenantNo());
            rrDTO.setCreator(entity.getOperator());
            roleResourceService.addBatchResource(rrDTO);
        }

        //设置不允许修改
        BeanUtils.copyProperties(entity, entity0);
        entity0.setUuid(null);
        this.updateById(entity0);
        return entity;
    }

    @Override
    @Transactional
    public RoleDTO delete(RoleDTO entity) {
        RolePO entity0 = this.getPoByUuid(entity.getUuid(), entity.getTenantNo());
        if (entity0 == null) {
            throw new CuscUserException(ResponseCode.ROLE_INVALID.getCode(),
                    ResponseCode.ROLE_INVALID.getMsg());
        }
        if (CommonDeleteEnum.DELETED.getCode() == entity0.getIsDelete()) {
            return RoleConverter.INSTANCE.poToDto(entity0);
        }

        //删除角色与资源的关系
        RoleResourceDTO rrDTO = new RoleResourceDTO();
        rrDTO.setRoleId(entity0.getUuid());
        rrDTO.setTenantNo(entity.getTenantNo());
        roleResourceService.addBatchResource(rrDTO);

        RolePO tmpRole = new RolePO();
        tmpRole.setId(entity0.getId());
        tmpRole.setIsDelete(CommonDeleteEnum.DELETED.getCode());
        tmpRole.setOperator(entity.getOperator());
        this.updateById(tmpRole);
        return RoleConverter.INSTANCE.poToDto(entity0);
    }

    @Override
    public RoleDTO get(RoleDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(null != entity.getId() ,"id", entity.getId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(entity.getRoleCode()),"role_code",entity.getRoleCode());
        queryWrapper.eq("is_delete", 0);
        queryWrapper.eq("tenant_no", entity.getTenantNo());
        queryWrapper.eq("application_id",entity.getApplicationId());
        RolePO record = this.getOne(queryWrapper);
        RoleDTO resp = new RoleDTO();
        if (record != null) {
            BeanUtils.copyProperties(record, resp);
        }
        return resp;
    }

    @Override
    public PageResult<RoleDTO> page(RoleDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc("create_time");
        queryWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq("tenant_no", entity.getTenantNo());

        queryWrapper.eq(CuscStringUtils.isNotEmpty(entity.getApplicationId()), "application_id",
                entity.getApplicationId());
        queryWrapper.eq(entity.getRoleType() != null, "role_type", entity.getRoleType());
        queryWrapper.eq(entity.getStatus() != null, "status", entity.getStatus());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(entity.getParentId()), "parent_id", entity.getParentId());
        queryWrapper.like(CuscStringUtils.isNotEmpty(entity.getRoleCode()), "role_code", entity.getRoleCode());
        queryWrapper.like(CuscStringUtils.isNotEmpty(entity.getRoleName()), "role_name", entity.getRoleName());
        queryWrapper.eq(entity.getId() != null, "id", entity.getId());
        if (!CollectionUtils.isEmpty(entity.getResourceUuidList())) {
            //查询条件如果传了资源id，则增加资源id的校验
            StringBuilder existsSql = new StringBuilder();
            for (String resUuid : entity.getResourceUuidList()) {
                existsSql.append("'");
                existsSql.append(CuscSqlUtils.transactSQLInjection(resUuid));
                existsSql.append("',");
            }
            existsSql.deleteCharAt(existsSql.length() - 1);
            queryWrapper.exists(
                    "select 1 from eiam_role_resource where is_delete = 0 and role_id = eiam_role.uuid and tenant_no "
                            + "= '"
                            + CuscSqlUtils.transactSQLInjection(entity.getTenantNo()) + "' and resource_id in  (" + existsSql + ")");
        }

        if (CuscStringUtils.isNotEmpty(entity.getPositionId())) {
            //查询岗位对应的角色信息
            queryWrapper.exists(
                    "select 1 from eiam_position_role where is_delete = 0 and role_id = eiam_role.uuid and tenant_no "
                            + "= '"
                            + CuscSqlUtils.transactSQLInjection(entity.getTenantNo()) + "' and  position_id = '" + CuscSqlUtils.transactSQLInjection(entity.getPositionId()) + "'");
        }

        if (CuscStringUtils.isNotEmpty(entity.getUserId())) {
            //查询岗位对应的角色信息
            queryWrapper.exists(
                    "select 1 from eiam_user_role where is_delete = 0 and role_id = eiam_role.uuid and tenant_no = '"
                            + CuscSqlUtils.transactSQLInjection(entity.getTenantNo()) + "' and user_id = '" + CuscSqlUtils.transactSQLInjection(entity.getPositionId()) + "'");
        }

        Page<UserPO> page =
                this.page(new Page<>(entity.getCurrPage(), entity.getPageSize()), queryWrapper);
        return PageHelper.convert(page, RoleDTO.class);
    }

    @Override
    public List<RoleSimpleDTO> query(RoleDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("is_delete", 0);
        queryWrapper.eq("tenant_no", entity.getTenantNo());
        queryWrapper.orderByDesc("create_time");

        queryWrapper.like(CuscStringUtils.isNotEmpty(entity.getRoleName()), "role_name", entity.getRoleName());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(entity.getRoleCode()), "role_code",
                entity.getRoleCode());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(entity.getUuid()), "uuid", entity.getUuid());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(entity.getApplicationId()), "application_id",
                entity.getApplicationId());
        queryWrapper.eq(entity.getRoleType() != null, "role_type", entity.getRoleType());
        queryWrapper.eq(entity.getRoleScene() != null, "role_scene", entity.getRoleScene());
        queryWrapper.eq(entity.getStatus() != null, "status", entity.getStatus());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(entity.getParentId()), "parent_id", entity.getParentId());

        List<RolePO> recordList = this.list(queryWrapper);
        return getRoleSimple(recordList);
    }

    @Override
    public RoleDTO getByUuid(RoleDTO bean) {
        RolePO rolePO = this.getPoByUuid(bean.getUuid(), bean.getTenantNo());
        return RoleConverter.INSTANCE.poToDto(rolePO);
    }

    @Override
    public List<RoleSimpleDTO> getByUuids(RoleDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in("uuid", entity.getUuidList());
        queryWrapper.eq("is_delete", 0);
        queryWrapper.eq("tenant_no", entity.getTenantNo());

        List<RolePO> recordList = this.list(queryWrapper);
        return getRoleSimple(recordList);
    }

    /**
     * Description: 通过用户id查询角色信息
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    @Override
    public List<RoleDTO> queryRoleByUserId(UserRoleDTO entity) {
        return RoleConverter.INSTANCE.poListToDtoList(baseMapper.queryRoleByUserId(entity));
    }

    @Override
    public List<RoleSimpleDTO> queryRoleByName(RoleDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("is_delete", 0);
        queryWrapper.eq("tenant_no", entity.getTenantNo());
        queryWrapper.eq("role_name", entity.getRoleName());
        queryWrapper.ne(entity.getId() != null, "id", entity.getId());
        queryWrapper.ne("uuid", entity.getUuid());

        List<RolePO> recordList = this.list(queryWrapper);
        return getRoleSimple(recordList);
    }

    @Override
    public RoleDTO frozen(RoleDTO bean) {
        RolePO rolePO = this.getPoByUuid(bean.getUuid(), bean.getTenantNo());
        if (rolePO == null) {
            throw new CuscUserException(ResponseCode.ROLE_INVALID.getCode(),
                    ResponseCode.ROLE_INVALID.getMsg());
        }
        RolePO tmpBean = new RolePO();
        tmpBean.setId(rolePO.getId());
        tmpBean.setStatus(CommonStatusEnum.DISABLE.getCode());
        this.updateById(tmpBean);
        return RoleConverter.INSTANCE.poToDto(rolePO);

    }

    @Override
    public RoleDTO unfreeze(RoleDTO bean) {
        RolePO rolePO = this.getPoByUuid(bean.getUuid(), bean.getTenantNo());
        if (rolePO == null) {
            throw new CuscUserException(ResponseCode.ROLE_INVALID.getCode(),
                    ResponseCode.ROLE_INVALID.getMsg());
        }
        RolePO tmpBean = new RolePO();
        tmpBean.setId(rolePO.getId());
        tmpBean.setStatus(CommonStatusEnum.ENABLE.getCode());
        this.updateById(tmpBean);
        return RoleConverter.INSTANCE.poToDto(rolePO);
    }

    @Override
    public Response<Boolean> queryHideSensitiveByUserId(UserRoleDTO bean) {
        List<RoleDTO> roleList = queryRoleByUserId(bean);
        if(CollectionUtils.isEmpty(roleList)){
            return Response.createSuccess(false);
        }
        for(RoleDTO role : roleList){
            if(role.getHideSensitiveInfo() != null && CommonYesOrNoEnum.YES.getCode() == role.getHideSensitiveInfo()){
                return Response.createSuccess(true);
            }
        }
        return Response.createSuccess(false);
    }

    //----------------私有方法区--------------------------------

    /**
     * Description:查询角色所有信息
     * <br />
     * CreateDate 2021-10-26 17:42:09
     *
     * @author yuyi
     **/
    private List<RoleSimpleDTO> queryRoleByParams(RoleDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("is_delete", 0);
        queryWrapper.orderByDesc("create_time");
        queryWrapper.eq("tenant_no", entity.getTenantNo());

        queryWrapper.eq(CuscStringUtils.isNotEmpty(entity.getRoleName()), "role_name", entity.getRoleName());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(entity.getRoleCode()), "role_code",
                entity.getRoleCode());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(entity.getUuid()), "uuid",
                entity.getUuid());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(entity.getApplicationId()), "application_id", entity.getApplicationId());
        queryWrapper.ne(entity.getId() != null, "id", entity.getId());
        return getRoleSimple(this.list(queryWrapper));
    }

    /**
     * 通过UUID查询单条数据
     *
     * @param uuid
     * @return 实例对象
     */
    private RolePO getPoByUuid(String uuid, String tenantNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("uuid", uuid);
        queryWrapper.eq("is_delete", 0);
        queryWrapper.eq("tenant_no", tenantNo);
        return this.getOne(queryWrapper);
    }

    /**
     * Description:将role对象转为role简单对象
     * <br />
     * CreateDate 2021-10-29 16:22:44
     *
     * @author yuyi
     **/
    private List<RoleSimpleDTO> getRoleSimple(List<RolePO> recordList) {
        List<RoleSimpleDTO> retList = new ArrayList<>();
        RoleSimpleDTO rsDto;

        for (RolePO role : recordList) {
            rsDto = new RoleSimpleDTO();
            BeanUtils.copyProperties(role, rsDto);
            retList.add(rsDto);
        }
        return retList;
    }
}
