package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.converter.ResourceTempalteConverter;
import com.cusc.nirvana.user.eiam.dao.ResourceTempalteDao;
import com.cusc.nirvana.user.eiam.dao.entity.ResourceTempaltePO;
import com.cusc.nirvana.user.eiam.dto.ResourceTempalteDTO;
import com.cusc.nirvana.user.eiam.service.IResourceTempalteService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * (ResourceTempalte)表服务实现类
 *
 * @author yuy336
 * @since 2022-01-11 17:34:45
 */
@Service
public class ResourceTempalteServiceImpl extends ServiceImpl<ResourceTempalteDao, ResourceTempaltePO>
        implements IResourceTempalteService {

    /**
     * 通过UUID查询单条数据
     *
     * @param resourceTempalte
     * @return 实例对象
     */
    @Override
    public ResourceTempalteDTO getByUuid(ResourceTempalteDTO resourceTempalte) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("uuid", resourceTempalte.getUuid());
        queryWrapper.eq("is_delete", 0);
        ResourceTempaltePO record = this.getOne(queryWrapper);
        return ResourceTempalteConverter.INSTANCE.poToDto(record);
    }

    /**
     * 通过查询条件查询集合数据
     *
     * @param resourceTempalte
     * @return 集合对象
     */
    @Override
    public List<ResourceTempalteDTO> queryByList(ResourceTempalteDTO resourceTempalte) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc("create_time");

        queryWrapper.eq(CuscStringUtils.isNotEmpty(resourceTempalte.getApplicationId()), "application_id",
                resourceTempalte.getApplicationId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(resourceTempalte.getRoleCode()), "role_code",
                resourceTempalte.getRoleCode());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(resourceTempalte.getResourceId()), "resource_id",
                resourceTempalte.getResourceId());
        List<ResourceTempaltePO> record = this.list(queryWrapper);
        return ResourceTempalteConverter.INSTANCE.poListToDtoList(record);
    }

    /**
     * 分页查询
     *
     * @param resourceTempalte 筛选条件
     * @return 查询结果
     */
    @Override
    public PageResult<ResourceTempalteDTO> queryByPage(ResourceTempalteDTO resourceTempalte) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc("create_time");
        queryWrapper.eq("is_delete", 0);

        Page<ResourceTempaltePO> page =
                this.page(new Page<>(resourceTempalte.getCurrPage(), resourceTempalte.getPageSize()), queryWrapper);
        return PageHelper.convert(page, ResourceTempalteDTO.class);
    }

    /**
     * 新增数据
     *
     * @param resourceTempalte 实例对象
     * @return 实例对象
     */
    @Override
    @Transactional
    public ResourceTempalteDTO insert(ResourceTempalteDTO resourceTempalte) {
        ResourceTempaltePO resourceTempaltePO = ResourceTempalteConverter.INSTANCE.dtoToPo(resourceTempalte);
        this.save(resourceTempaltePO);
        return resourceTempalte;
    }

    /**
     * 修改数据
     *
     * @param resourceTempalte 实例对象
     * @return 实例对象
     */
    @Override
    @Transactional
    public ResourceTempalteDTO update(ResourceTempalteDTO resourceTempalte) {
        ResourceTempaltePO resourceTempaltePO = this.getPoByUuid(resourceTempalte.getUuid());
        this.updateById(resourceTempaltePO);
        return resourceTempalte;
    }

    /**
     * 通过主键删除数据
     *
     * @param resourceTempalte 实例对象
     * @return 是否成功
     */
    @Override
    @Transactional
    public boolean deleteById(ResourceTempalteDTO resourceTempalte) {
        ResourceTempaltePO resourceTempaltePO = this.getPoByUuid(resourceTempalte.getUuid());
        return this.updateById(resourceTempaltePO);
    }

    @Override
    public List<String> queryResourceIdList(ResourceTempalteDTO bean) {
        return baseMapper.queryResourceIdList(bean.getApplicationId(), bean.getRoleCode());
    }

    /**
     * 通过UUID查询单条数据
     *
     * @param uuid
     * @return 实例对象
     */
    private ResourceTempaltePO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("uuid", uuid);
        queryWrapper.eq("is_delete", 0);
        return this.getOne(queryWrapper);
    }
}
