package com.cusc.nirvana.user.eiam.service.impl;

import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.RedisConstant;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.UserTokenListDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * Description: 令牌service实现类
 * <br />
 * CreateDate 2021-11-02 20:25:49
 *
 * @author yuyi
 **/
@Service
@Slf4j
public class EiamTokenService {

    @Autowired
    private CacheFactory cacheFactory;

    /**
     * Description: 根据用户id和租户编号踢出
     * <br />
     * CreateDate 2022-02-17 19:58:58
     *
     * @author yuyi
     **/
    public Response kickOutByUserId(String userId, String tenantNo ) {
        //通过用户id和应用id找到对应的token信息
        try {
            String userTokenListKey = RedisConstant.TOKEN_USER_TOKEN_INFO + tenantNo + ":" + userId;
            List<UserTokenListDTO> userList =
                    cacheFactory.getExpireListService().getList(userTokenListKey, UserTokenListDTO.class);
            if (CollectionUtils.isEmpty(userList)) {
                return Response.createSuccess();
            }
            for (UserTokenListDTO userToken : userList) {
                //删除刷新token
                cacheFactory.getExpireHashService()
                        .delete(RedisConstant.TOKEN_REFRESH_TOKEN_INFO + userToken.getRefresh());

                //删除访问token
                cacheFactory.getExpireHashService()
                        .delete(RedisConstant.TOKEN_ACCESS_TOKEN_INFO + userToken.getAccess());
            }
            //删除用户token的集合
            cacheFactory.getExpireListService().delete(userTokenListKey);
        } catch (CacheException e) {
            log.error("kickOutByUserId 访问reids失败 :{}", e);
            return Response.createError(ResponseCode.KICK_OUT_FAIL.getMsg(), ResponseCode.KICK_OUT_FAIL.getCode() + "");
        }
        return Response.createSuccess();
    }
}
