package com.cusc.nirvana.user.eiam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.user.eiam.dao.entity.UserPO;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.eiam.dto.UserPasswordDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.dto.UserSimpleDTO;

import java.util.List;

/**
 * <p>
 * 针对内部员工、生态合作伙伴、分级线下店铺等企业内部用户 服务类
 * </p>
 *
 * @author yuy336
 * @since 2021-10-20
 */
public interface IUserService extends IService<UserPO> {

    /**
     * Description:新增用户
     * <br />
     * CreateDate 2021-10-26 17:40:21
     *
     * @author yuyi
     **/
    UserDTO addUser(UserDTO entity);

    /**
     * Description:更新用户信息
     * <br />
     * CreateDate 2021-10-26 17:40:39
     *
     * @author yuyi
     **/
    UserDTO updateUser(UserDTO entity);

    /**
     * Description:删除用户信息
     * <br />
     * CreateDate 2021-10-26 17:40:39
     *
     * @author yuyi
     **/
    boolean deleteUser(UserDTO entity);

    /**
     * Description:通过id查询用户详情
     * <br />
     * CreateDate 2021-10-26 17:40:54
     *
     * @author yuyi
     **/
    UserDTO getUser(UserDTO entity);

    /**
     * Description:分页查询用户信息
     * <br />
     * CreateDate 2021-10-26 17:41:59
     *
     * @author yuyi
     **/
    PageResult<UserDTO> pageListUser(UserDTO entity);

    /**
     * Description:查询用户所有信息
     * <br />
     * CreateDate 2021-10-26 17:42:09
     *
     * @author yuyi
     **/
    List<UserSimpleDTO> queryListUser(UserDTO entity);

    /**
     * Description: 冻结用户
     * <br />
     * CreateDate 2021-10-29 15:36:34
     *
     * @author yuyi
     **/
    boolean frozen(UserDTO entity);

    /**
     * Description: 解冻用户
     * <br />
     * CreateDate 2021-10-29 15:36:34
     *
     * @author yuyi
     **/
    boolean unfreeze(UserDTO entity);

    /**
     * Description:通过id查询用户详情
     * <br />
     * CreateDate 2021-10-26 17:41:12
     *
     * @author yuyi
     **/
    UserDTO getByUuid(UserDTO entity);

    /**
     * Description:通过id集合查询用户详情
     * <br />
     * CreateDate 2021-10-26 17:41:29
     *
     * @author yuyi
     **/
    List<UserSimpleDTO> getByUuids(UserDTO entity);

    /**
     * Description: 通过角色id查询用户信息
     * <br />
     * CreateDate 2021-10-29 17:09:57
     *
     * @author yuyi
     **/
    List<UserDTO> queryUserByRoleId(UserRoleDTO entity);

    /**
     * Description: 更换租户管理员账号
     * <br />
     * CreateDate 2022-01-20 11:48:36
     *
     * @author yuyi
     **/
    boolean changeTenantAdmin(UserDTO bean);

    /**
     * Description: 将租户下的所有用户对应的url写入redis
     * <br />
     * CreateDate 2022-01-20 11:48:36
     *
     * @author yuyi
     **/
    void allUserRelUrlToRedis(UserDTO bean);

    /**
     * Description: 修改密码
     * <br />
     * CreateDate 2022-01-21 15:36:34
     *
     * @author yuyi
     **/
    boolean changePassword(UserDTO bean);

    /**
     * Description: 重置密码
     * <br />
     * CreateDate 2022-01-21 15:36:34
     *
     * @author yuyi
     **/
    boolean resetPassword(UserPasswordDTO bean);

    /**
     * Description: 查询用户是否在线
     * <br />
     * CreateDate 2022-01-21 15:36:34
     *
     * @author yuyi
     **/
    boolean getUserOnline(UserDTO bean);

	/**
	 * 查询管理员
	 * @param userIdList userIdList
	 * @param tenantAdmin 是否租户管理员
	 * @return
	 */
	List<UserDTO> queryAdminUserListByUserIdList(List<String> userIdList,boolean tenantAdmin);

    List<UserDTO> queryAdminUserListByUserIdListNew(List<String> userIdList,boolean tenantAdmin);

}
