package com.cusc.nirvana.user.eiam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.user.eiam.dao.entity.UserOrganPO;
import com.cusc.nirvana.user.eiam.dto.UserOrganDTO;

import java.util.List;

/**
 * 用户组织信息(UserOrgan)表服务接口
 *
 * @author yuy336
 * @since 2022-01-12 15:00:02
 */
public interface IUserOrganService extends IService<UserOrganPO> {

    /**
     * 通过UUID查询单条数据
     *
     * @param userOrgan
     * @return 实例对象
     */
    UserOrganDTO getByUuid(UserOrganDTO userOrgan);
    
     /**
     * 通过查询条件查询集合数据
     *
     * @param userOrgan
     * @return 集合对象
     */
    List<UserOrganDTO> queryByList(UserOrganDTO userOrgan);

    /**
     * 分页查询
     *
     * @param userOrgan 筛选条件
     * @return 查询结果
     */
    PageResult<UserOrganDTO> queryByPage(UserOrganDTO userOrgan);

    /**
     * 新增数据
     *
     * @param userOrgan 实例对象
     * @return 实例对象
     */
    UserOrganDTO insert(UserOrganDTO userOrgan);

    /**
     * 修改数据
     *
     * @param userOrgan 实例对象
     * @return 实例对象
     */
    UserOrganDTO update(UserOrganDTO userOrgan);

    /**
     * 通过主键删除数据
     *
     * @param userOrgan
     * @return 是否成功
     */
    boolean deleteById(UserOrganDTO userOrgan);

}
