package com.cusc.nirvana.user.eiam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.dao.entity.RolePO;
import com.cusc.nirvana.user.eiam.dto.RoleDTO;
import com.cusc.nirvana.user.eiam.dto.RoleSimpleDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author auto-generator
 * @since 2021-10-20
 */
public interface IRoleService extends IService<RolePO> {
    /**
     * Description:新增角色
     * <br />
     * CreateDate 2021-10-26 17:40:21
     *
     * @author yuyi
     **/
    RoleDTO add(RoleDTO entity);

    /**
     * Description:更新角色信息
     * <br />
     * CreateDate 2021-10-26 17:40:39
     *
     * @author yuyi
     **/
    RoleDTO update(RoleDTO entity);

    /**
     * Description:删除角色信息
     * <br />
     * CreateDate 2021-10-26 17:40:39
     *
     * @author yuyi
     **/
    RoleDTO delete(RoleDTO entity);

    /**
     * Description:通过id查询角色详情
     * <br />
     * CreateDate 2021-10-26 17:40:54
     *
     * @author yuyi
     **/
    RoleDTO get(RoleDTO entity);

    /**
     * Description:分页查询角色信息
     * <br />
     * CreateDate 2021-10-26 17:41:59
     *
     * @author yuyi
     **/
    PageResult<RoleDTO> page(RoleDTO entity);

    /**
     * Description:查询角色所有信息
     * <br />
     * CreateDate 2021-10-26 17:42:09
     *
     * @author yuyi
     **/
    List<RoleSimpleDTO> query(RoleDTO entity);

    /**
     * Description:通过id查询角色详情
     * <br />
     * CreateDate 2021-10-26 17:41:12
     *
     * @author yuyi
     **/
    RoleDTO getByUuid(RoleDTO entity);

    /**
     * Description:通过id集合查询角色详情
     * <br />
     * CreateDate 2021-10-26 17:41:29
     *
     * @author yuyi
     **/
    List<RoleSimpleDTO> getByUuids(RoleDTO entity);

    /**
     * Description: 通过用户id查询角色信息
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    List<RoleDTO> queryRoleByUserId(UserRoleDTO entity);

    /**
     * Description: 通过角色名称查询角色信息
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    List<RoleSimpleDTO> queryRoleByName(RoleDTO entity);

    /**
     * 冻结数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    RoleDTO frozen(RoleDTO bean);

    /**
     * 解冻数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    RoleDTO unfreeze(RoleDTO bean);

    /**
     * Description: 通过用户id查询是否脱敏  false 脱敏，  true 不脱敏
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    Response<Boolean> queryHideSensitiveByUserId(UserRoleDTO bean);
}
