package com.cusc.nirvana.user.eiam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.dao.entity.ResourcePO;
import com.cusc.nirvana.user.eiam.dto.*;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author auto-generator
 * @since 2021-10-20
 */
public interface IResourceService extends IService<ResourcePO> {
    /**
     * Description: 通过角色id查询资源信息
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    List<ResourceDTO> queryResourceByRoleId(RoleResourceDTO entity);

    /**
     * Description:查询资源所有信息
     * <br />
     * CreateDate 2021-10-26 17:42:09
     *
     * @author yuyi
     **/
    Response<List<ResourceSimpleDTO>> query(ResourceDTO entity);

    /**
     * Description:资源批量新增
     * <br />
     * CreateDate 2021-10-26 17:40:21
     *
     * @author yuyi
     **/
    Response addList(ResourceBatchDTO resourceBatch);

    /**
     * Description: 通过用户id查询资源信息
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    List<ResourceSimpleDTO> queryResourceByUserId(UserRoleDTO entity);

    /**
     * Description: 通过角色code查询资源信息
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    ResourcePO getResourceDOByCode(ResourceDTO entity);

    /**
     * Description:根据资源编码和应用id删除资源信息
     * <br />
     * CreateDate 2021-10-26 17:40:39
     *
     * @author yuyi
     **/
    Integer deleteByCode(List<String> codeList, String appId);

    /**
     * Description: 比对输入的数据和数据库中的资源
     * <br />
     * CreateDate 2021-12-08 20:52:26
     *
     * @author yuyi
     **/
    void compareResource(List<ResourceTreeDTO> resourceList);

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    PageResult<ResourceDTO> queryByPage(ResourceDTO bean);

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    ResourceDTO getByUuid(ResourceDTO bean);

    /**
     * 新增数据
     *
     * @param resource 实体
     * @return 新增结果
     */
    ResourceDTO add(ResourceDTO resource);

    /**
     * 编辑数据
     *
     * @param resource 实体
     * @return 编辑结果
     */
    ResourceDTO update(ResourceDTO resource);

    /**
     * 删除数据
     *
     * @param resource 实体
     * @return 删除是否成功
     */
    boolean deleteById(ResourceDTO resource);

    /**
     * 冻结数据
     *
     * @param resource 实体
     * @return 删除是否成功
     */
    boolean frozen(ResourceDTO resource);

    /**
     * 解冻数据
     *
     * @param resource 实体
     * @return 删除是否成功
     */
    boolean unfreeze(ResourceDTO resource);

    /**
     * 生成资源sql
     *
     * @param bean 实体
     * @return sql集合
     */
    Response<List<String>> generateResSql(ResourceDTO bean);
}
