package com.cusc.nirvana.user.eiam.service;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.dto.ApplicationDTO;
import com.cusc.nirvana.user.eiam.dto.SmsResponseDTO;
import com.cusc.nirvana.user.eiam.dto.SmsSendConfig;

import java.util.List;

/**
 * Description: 短信service
 * <br />
 * CreateDate 2021-11-02 20:25:19
 *
 * @author yuyi
 **/
public interface IEiamSmsService {

    /**
     * Description: 发送短信-多个参数
     * <br />
     * CreateDate 2021-12-03 14:53:06
     *
     * @author yuyi
     **/
    SmsResponseDTO sendSms(String phone, List<String> paramterList, SmsSendConfig config);

    /**
     * Description: 发送短信-单个参数
     * <br />
     * CreateDate 2021-12-03 14:53:06
     *
     * @author yuyi
     **/
    SmsResponseDTO sendSms(String phone, String paramter, SmsSendConfig config);

    /**
     * Description: 检查短信配置是否为空
     * <br />
     * CreateDate 2022-01-27 14:43:41
     *
     * @author yuyi
     **/
    boolean checkSmsConfigNotNull(SmsSendConfig bean);

    /**
     * Description: 短信发送限制检查
     * <br />
     * CreateDate 2022-01-27 14:43:41
     *
     * @author yuyi
     **/
    void checkSmsSendLimit(String phone, SmsSendConfig bean);

    /**
     * Description: 从应用配置转短信配置
     * <br />
     * CreateDate 2022-01-27 14:43:41
     *
     * @author yuyi
     **/
    void convertToSmsConfig(ApplicationDTO fromBean, SmsSendConfig toBean);

    /**
     * Description: 检查短信验证码
     * <br />
     * CreateDate 2021-11-04 19:53:41
     *
     * @author yuyi
     **/
    Response<Boolean> checkSmsCaptcha(String phone, String tenantNo, String appId, String smsCode);
}
