package com.cusc.nirvana.user.eiam.dao.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.cusc.nirvana.user.eiam.common.BaseIamPO;

import java.util.Date;

/**
 * <p>
 * 针对内部员工、生态合作伙伴、分级线下店铺等企业内部用户
 * </p>
 *
 * @author yuy336
 * @since 2021-10-20
 */
@TableName("eiam_user")
public class UserPO extends BaseIamPO {

    @TableField("uuid")
    private String uuid;

    /**
     * 用户名
     */
    @TableField("user_name")
    private String userName;

    /**
     * 用户姓名
     */
    @TableField("full_name")
    private String fullName;

    /**
     * 用户密码
     */
    @TableField(value = "password")
    private String password;

    /**
     * 昵称
     */
    @TableField(value = "nick_name")
    private String nickName;

    /**
     * 邮箱
     */
    @TableField("email")
    private String email;

    /**
     * 手机号
     */
    @TableField("phone")
    private String phone;

    /**
     * 用户状态 0 禁用 1启用
     */
    @TableField("status")
    private Integer status;

    /**
     * 租户id
     */
    @TableField("tenant_no")
    private String tenantNo;

    /**
     * 工号
     */
    @TableField("emp_no")
    private String empNo;

    /**
     * 入职时间
     */
    @TableField("entry_date")
    private Date entryDate;

    /**
     * 最后一次操作人
     */
    @TableField("operator")
    private String operator;

    /**
     * 是否是平台管理员 0 不是 1 是
     */
    @TableField("is_platform_admin")
    private Integer isPlatformAdmin;

    /**
     * 是否是租户管理员 0 不是 1 是
     */
    @TableField("is_tenant_admin")
    private Integer isTenantAdmin;

	/**
	 * 普通管理员类型 0:不是任何管理员 1:车企经销商管理员
	 */
	@TableField("ordinary_admin")
	private Integer ordinaryAdmin;


    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getTenantNo() {
        return tenantNo;
    }

    public void setTenantNo(String tenantNo) {
        this.tenantNo = tenantNo;
    }

    public String getEmpNo() {
        return empNo;
    }

    public void setEmpNo(String empNo) {
        this.empNo = empNo;
    }

    public Date getEntryDate() {
        return entryDate;
    }

    public void setEntryDate(Date entryDate) {
        this.entryDate = entryDate;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Integer getIsPlatformAdmin() {
        return isPlatformAdmin;
    }

    public void setIsPlatformAdmin(Integer isPlatformAdmin) {
        this.isPlatformAdmin = isPlatformAdmin;
    }

    public Integer getIsTenantAdmin() {
        return isTenantAdmin;
    }

    public void setIsTenantAdmin(Integer isTenantAdmin) {
        this.isTenantAdmin = isTenantAdmin;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

	public Integer getOrdinaryAdmin() {
		return ordinaryAdmin;
	}

	public void setOrdinaryAdmin(Integer ordinaryAdmin) {
		this.ordinaryAdmin = ordinaryAdmin;
	}

	@Override
    public String toString() {
        return "UserPO{" +
                "uuid='" + uuid + '\'' +
                ", userName='" + userName + '\'' +
                ", fullName='" + fullName + '\'' +
                ", password='" + password + '\'' +
                ", email='" + email + '\'' +
                ", phone='" + phone + '\'' +
                ", status=" + status +
                ", tenantNo='" + tenantNo + '\'' +
                ", empNo='" + empNo + '\'' +
                ", entryDate=" + entryDate +
                ", operator='" + operator + '\'' +
                ", isPlatformAdmin=" + isPlatformAdmin +
                ", isTenantAdmin=" + isTenantAdmin +
                "} " + super.toString();
    }
}
