package com.cusc.nirvana.user.eiam.dao.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.cusc.nirvana.user.eiam.common.BaseIamPO;

/**
 * <p>
 * 角色信息
 * </p>
 *
 * @author yuy336
 * @since 2021-10-20
 */
@TableName("eiam_role")
public class RolePO extends BaseIamPO {

    @TableField("uuid")
    private String uuid;

    /**
     * 角色场景：1 租户角色  2 用户角色
     */
    @TableField(value = "role_scene", updateStrategy = FieldStrategy.NEVER)
    private Integer roleScene;

    /**
     * 角色类型：1 平台管理员、2 租户管理员、3 审计员、4 普通角色
     */
    @TableField("role_type")
    private Integer roleType;

    /**
     * 角色编码
     */
    @TableField("role_code")
    private String roleCode;

    /**
     * 角色名称
     */
    @TableField("role_name")
    private String roleName;

    /**
     * 角色描述
     */
    @TableField("description")
    private String description;

    /**
     * 父级角色id
     */
    @TableField("parent_id")
    private String parentId;

    /**
     * 应用id
     */
    @TableField(value = "application_id", updateStrategy = FieldStrategy.NEVER)
    private String applicationId;

    /**
     * 租户id
     */
    @TableField(value = "tenant_no", updateStrategy = FieldStrategy.NEVER)
    private String tenantNo;

    /**
     * 状态： 0 禁用 1启用
     */
    @TableField("status")
    private Integer status;

    /**
     * 是否脱敏: 0 脱敏  1 不脱敏
     */
    @TableField("hide_sensitive_info")
    private Integer hideSensitiveInfo;

    /**
     * 展示顺序，数字越大越靠前
     */
    @TableField("display_sort")
    private Integer displaySort;

    /**
     * 操作人
     */
    @TableField("operator")
    private String operator;

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public Integer getRoleScene() {
        return roleScene;
    }

    public void setRoleScene(Integer roleScene) {
        this.roleScene = roleScene;
    }

    public Integer getRoleType() {
        return roleType;
    }

    public void setRoleType(Integer roleType) {
        this.roleType = roleType;
    }

    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getTenantNo() {
        return tenantNo;
    }

    public void setTenantNo(String tenantNo) {
        this.tenantNo = tenantNo;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getDisplaySort() {
        return displaySort;
    }

    public void setDisplaySort(Integer displaySort) {
        this.displaySort = displaySort;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Integer getHideSensitiveInfo() {
        return hideSensitiveInfo;
    }

    public void setHideSensitiveInfo(Integer hideSensitiveInfo) {
        this.hideSensitiveInfo = hideSensitiveInfo;
    }

    @Override
    public String toString() {
        return "RolePO{" +
                "uuid='" + uuid + '\'' +
                ", roleScene=" + roleScene +
                ", roleType=" + roleType +
                ", roleCode='" + roleCode + '\'' +
                ", roleName='" + roleName + '\'' +
                ", description='" + description + '\'' +
                ", parentId='" + parentId + '\'' +
                ", applicationId='" + applicationId + '\'' +
                ", tenantNo='" + tenantNo + '\'' +
                ", status=" + status +
                ", hideSensitiveInfo=" + hideSensitiveInfo +
                ", displaySort=" + displaySort +
                ", operator='" + operator + '\'' +
                "} " + super.toString();
    }
}
