package com.cusc.nirvana.user.eiam.dao.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.cusc.nirvana.user.eiam.common.BaseIamPO;

/**
 * (Application)实体类
 *
 * @author yuy336
 * @since 2022-01-11 17:09:05
 */
@TableName("eiam_application")
public class ApplicationPO extends BaseIamPO {

    private static final long serialVersionUID = -59736937390332869L;

    /**
     * 应用编码
     */
    @TableField("application_code")
    private String applicationCode;

    /**
     * 应用名称
     */
    @TableField("application_name")
    private String applicationName;

    /**
     * 访问令牌有效期（秒）
     */
    @TableField("access_token_term")
    private Integer accessTokenTerm;

    /**
     * token续期时间，单位秒，大于表示需求，小于等于0则不续期
     */
    @TableField("renewal_token_time")
    private Integer renewalTokenTime;

    /**
     * 刷新令牌有效期（秒）
     */
    @TableField("refresh_token_term")
    private Integer refreshTokenTerm;

    /**
     * 应用秘钥
     */
    @TableField("app_secret")
    private String appSecret;

    /**
     * 是否限制单设备登录
     */
    @TableField("is_device_login")
    private Integer isDeviceLogin;

    /**
     * 是否打开url鉴权
     */
    @TableField("open_auth")
    private Integer openAuth;

    /**
     * 是否强制修改密码
     */
    @TableField("is_force_change_pwd")
    private Integer isForceChangePwd;

    /**
     * 密码错误期限（秒）
     */
    @TableField("pws_error_lock_term")
    private Integer pwsErrorLockTerm;

    /**
     * 密码错误次数
     */
    @TableField("pws_error_lock_num")
    private Integer pwsErrorLockNum;

    /**
     * 密码错误锁定时长（秒）
     */
    @TableField("pws_error_lock_time")
    private Integer pwsErrorLockTime;

    /**
     * 短信验证码发送总次数限制（天）
     */
    @TableField("sms_total_limit")
    private Integer smsTotalLimit;

    /**
     * 短信验证码发送间隔限制（秒）
     */
    @TableField("sms_interval_limit")
    private Integer smsIntervalLimit;

    /**
     * 短信签名
     */
    @TableField("sms_signature_code")
    private String smsSignatureCode;

    /**
     * 短信平台key
     */
    @TableField("sms_platform_key")
    private String smsPlatformKey;

    /**
     * 状态： 0 禁用 1启用
     */
    @TableField("status")
    private Integer status;

    /**
     * 最后一次操作人
     */
    @TableField("operator")
    private String operator;


    public String getApplicationCode() {
        return applicationCode;
    }

    public void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public String getApplicationName() {
        return applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public Integer getAccessTokenTerm() {
        return accessTokenTerm;
    }

    public void setAccessTokenTerm(Integer accessTokenTerm) {
        this.accessTokenTerm = accessTokenTerm;
    }

    public Integer getRenewalTokenTime() {
        return renewalTokenTime;
    }

    public void setRenewalTokenTime(Integer renewalTokenTime) {
        this.renewalTokenTime = renewalTokenTime;
    }

    public Integer getRefreshTokenTerm() {
        return refreshTokenTerm;
    }

    public void setRefreshTokenTerm(Integer refreshTokenTerm) {
        this.refreshTokenTerm = refreshTokenTerm;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public Integer getIsDeviceLogin() {
        return isDeviceLogin;
    }

    public void setIsDeviceLogin(Integer isDeviceLogin) {
        this.isDeviceLogin = isDeviceLogin;
    }

    public Integer getOpenAuth() {
        return openAuth;
    }

    public void setOpenAuth(Integer openAuth) {
        this.openAuth = openAuth;
    }

    public Integer getIsForceChangePwd() {
        return isForceChangePwd;
    }

    public void setIsForceChangePwd(Integer isForceChangePwd) {
        this.isForceChangePwd = isForceChangePwd;
    }

    public Integer getPwsErrorLockTerm() {
        return pwsErrorLockTerm;
    }

    public void setPwsErrorLockTerm(Integer pwsErrorLockTerm) {
        this.pwsErrorLockTerm = pwsErrorLockTerm;
    }

    public Integer getPwsErrorLockNum() {
        return pwsErrorLockNum;
    }

    public void setPwsErrorLockNum(Integer pwsErrorLockNum) {
        this.pwsErrorLockNum = pwsErrorLockNum;
    }

    public Integer getPwsErrorLockTime() {
        return pwsErrorLockTime;
    }

    public void setPwsErrorLockTime(Integer pwsErrorLockTime) {
        this.pwsErrorLockTime = pwsErrorLockTime;
    }

    public Integer getSmsTotalLimit() {
        return smsTotalLimit;
    }

    public void setSmsTotalLimit(Integer smsTotalLimit) {
        this.smsTotalLimit = smsTotalLimit;
    }

    public Integer getSmsIntervalLimit() {
        return smsIntervalLimit;
    }

    public void setSmsIntervalLimit(Integer smsIntervalLimit) {
        this.smsIntervalLimit = smsIntervalLimit;
    }

    public String getSmsSignatureCode() {
        return smsSignatureCode;
    }

    public void setSmsSignatureCode(String smsSignatureCode) {
        this.smsSignatureCode = smsSignatureCode;
    }

    public String getSmsPlatformKey() {
        return smsPlatformKey;
    }

    public void setSmsPlatformKey(String smsPlatformKey) {
        this.smsPlatformKey = smsPlatformKey;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

}

