package com.cusc.nirvana.user.eiam.converter;

import com.cusc.nirvana.user.eiam.dao.entity.ResourcePO;
import com.cusc.nirvana.user.eiam.dto.ResourceDTO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * (resource)表服务接口
 *
 * @author yuy336
 * @since 2022-01-11 17:09:08
 */
@Mapper
public interface ResourceConverter {

    ResourceConverter INSTANCE = Mappers.getMapper(ResourceConverter.class);

    /**
     * Description: do 转 dto
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    ResourceDTO poToDto(ResourcePO bean);

    /**
     * Description: dto 转 do
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    ResourcePO dtoToPo(ResourceDTO bean);

    /**
     * Description: do list 转 dto list
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    List<ResourceDTO> poListToDtoList(List<ResourcePO> list);
}
