package com.cusc.nirvana.user.eiam.converter;

import com.cusc.nirvana.user.eiam.dao.entity.DataOperationLogPO;
import com.cusc.nirvana.user.eiam.dto.DataOperationLogDTO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * eiam数据操作历史(DataOperationLog)表服务接口
 *
 * @author yuy336
 * @since 2022-01-12 15:02:10
 */
@Mapper
public interface DataOperationLogConverter {

    DataOperationLogConverter INSTANCE = Mappers.getMapper(DataOperationLogConverter.class);

    /**
     * Description: do 转 dto
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    DataOperationLogDTO poToDto(DataOperationLogPO bean);

    /**
     * Description: dto 转 do
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    DataOperationLogPO dtoToPo(DataOperationLogDTO bean);

    /**
     * Description: do list 转 dto list
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    List<DataOperationLogDTO> poListToDtoList(List<DataOperationLogPO> list);
}
