package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.service.IUserRoleService;
import com.cusc.nirvana.user.eiam.service.IUserService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 用户角色控制器
 * </p>
 *
 * @author auto-generator
 * @since 2021-10-20
 */
@Slf4j
@RestController
@RequestMapping("/userRole")
public class UserRoleController {

    @Autowired
    IUserRoleService userRoleService;
    @Autowired
    IUserService userService;

    @PostMapping("/add")
    @ApiOperation(value = "用户角色信息", notes = "用户角色信息")
    public Response add(@RequestBody UserRoleDTO entity) {
        return Response.createSuccess(userRoleService.add(entity));
    }

    @PostMapping("/addBatchUserList")
    @ApiOperation(value = "批量新增用户角色信息", notes = "批量新增用户角色信息")
    public Response addBatchUserList(@RequestBody UserRoleDTO entity) {
        if (CuscStringUtils.isEmpty(entity.getUserId()) || CuscStringUtils.isEmpty(entity.getTenantNo()) || CuscStringUtils.isEmpty(entity.getApplicationId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(userRoleService.addBatchRole(entity));
    }

    @PostMapping("/delBatchUser")
    @ApiOperation(value = "通过用户id删除用户角色关系", notes = "通过用户id删除用户角色关系")
    public Response delBatchUser(@RequestBody UserRoleDTO entity) {
        if (CuscStringUtils.isEmpty(entity.getUserId()) || CuscStringUtils.isEmpty(entity.getTenantNo()) || CuscStringUtils.isEmpty(entity.getApplicationId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(userRoleService.delBatchUser(entity));
    }

    @PostMapping("/updateByUserId")
	public Response updateByUserId(@RequestBody UserRoleDTO dto){
    	userRoleService.updateByUserId(dto);
    	return Response.createSuccess();
	}

	@PostMapping("/queryListByUserIdList")
	public Response<List<UserRoleDTO>> queryListByUserIdList(@RequestBody UserRoleDTO dto){
    	return Response.createSuccess(userRoleService.queryListByUserIdList(dto));
	}

    /**
     * 通过主键查询单条数据
     *
     * @param userRole 实体
     * @return 单条数据
     */
    @PostMapping("/queryByList")
    public Response<List<UserRoleDTO>> queryByList(@RequestBody UserRoleDTO userRole) {
        return Response.createSuccess(this.userRoleService.queryByList(userRole));
    }
}
