package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.RoleDTO;
import com.cusc.nirvana.user.eiam.dto.RoleSimpleDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.service.IRoleService;
import com.cusc.nirvana.user.eiam.service.IUrlService;
import com.cusc.nirvana.user.eiam.util.CommonParamterCheck;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 角色管理
 * </p>
 *
 * @author auto-generator
 * @since 2021-10-20
 */
@Slf4j
@RestController
@RequestMapping("/role")
public class RoleController {

    @Autowired
    private IRoleService roleService;
    @Autowired
    private IUrlService urlService;

    @PostMapping("/add")
    @ApiOperation(value = "新增角色", notes = "新增角色")
    public Response add(@RequestBody RoleDTO entity) {
        if (CuscStringUtils.isEmpty(entity.getRoleCode()) || CuscStringUtils.isEmpty(entity.getRoleName()) || entity.getRoleType() == null) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(entity.getApplicationId(), entity.getTenantNo());
        RoleDTO ret = roleService.add(entity);
        urlService.roleRelUrlToRedis(ret.getUuid(), ret.getRoleScene(), ret.getTenantNo(), ret.getApplicationId());
        return Response.createSuccess(ret);
    }

    @PostMapping("/update")
    @ApiOperation(value = "更新角色", notes = "更新角色")
    public Response update(@RequestBody RoleDTO entity) {
        if (CuscStringUtils.isEmpty(entity.getUuid())) {
            return Response.createError(ResponseCode.ROLE_UUID_NOT_NULL.getMsg(),
                    ResponseCode.ROLE_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(entity.getApplicationId(), entity.getTenantNo());
        RoleDTO ret = roleService.update(entity);
        urlService.roleRelUrlToRedis(ret.getUuid(), ret.getRoleScene(), ret.getTenantNo(), ret.getApplicationId());
        return Response.createSuccess(ret);
    }

    @PostMapping("/delete")
    @ApiOperation(value = "删除角色", notes = "删除角色")
    public Response delete(@RequestBody RoleDTO entity) {
        if (CuscStringUtils.isEmpty(entity.getUuid())) {
            return Response.createError(ResponseCode.ROLE_UUID_NOT_NULL.getMsg(),
                    ResponseCode.ROLE_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(entity.getApplicationId(), entity.getTenantNo());
        RoleDTO ret = roleService.delete(entity);
        urlService.roleRelUrlToRedis(ret.getUuid(), ret.getRoleScene(), ret.getTenantNo(), ret.getApplicationId());
        return Response.createSuccess(true);
    }

    @PostMapping("/query")
    @ApiOperation(value = "查询角色", notes = "查询角色")
    public Response<List<RoleSimpleDTO>> query(@RequestBody RoleDTO entity) {
        CommonParamterCheck.appIdAndTenantNoRequired(entity.getApplicationId(), entity.getTenantNo());
        return Response.createSuccess(roleService.query(entity));
    }

    @PostMapping("/get")
    @ApiOperation(value = "查询单个角色", notes = "查询单个角色")
    public Response<RoleDTO> get(@RequestBody RoleDTO entity) {
        CommonParamterCheck.appIdAndTenantNoRequired(entity.getApplicationId(), entity.getTenantNo());
        return Response.createSuccess(roleService.get(entity));
    }

    @PostMapping("/page")
    @ApiOperation(value = "分页查询(page)", notes = "分页查询")
    public Response<PageResult<RoleDTO>> page(@RequestBody RoleDTO entity) {
        CommonParamterCheck.appIdAndTenantNoRequired(entity.getApplicationId(), entity.getTenantNo());
        return Response.createSuccess(roleService.page(entity));
    }

    @PostMapping("/getByUuid")
    @ApiOperation(value = "通过id查询角色详情", notes = "通过id查询角色详情")
    public Response<RoleDTO> getByUuid(@RequestBody RoleDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty(entity.getUuid())) {
            return Response.createError(ResponseCode.ROLE_UUID_NOT_NULL.getMsg(),
                    ResponseCode.ROLE_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(entity.getApplicationId(), entity.getTenantNo());
        return Response.createSuccess(roleService.getByUuid(entity));
    }

    @PostMapping("/getByUuids")
    @ApiOperation(value = "通过id集合查询角色详情", notes = "通过id集合查询角色详情")
    public Response<List<RoleSimpleDTO>> getByUuids(@RequestBody RoleDTO entity) {
        if (CollectionUtils.isEmpty(entity.getUuidList())) {
            return Response.createError(ResponseCode.ROLE_UUID_NOT_NULL.getMsg(),
                    ResponseCode.ROLE_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(entity.getApplicationId(), entity.getTenantNo());
        return Response.createSuccess(roleService.getByUuids(entity));
    }

    @PostMapping("/queryRoleByUserId")
    @ApiOperation(value = "通过用户id查询角色信息", notes = "通过用户id查询角色信息")
    public Response<List<RoleDTO>> queryRoleByUserId(@RequestBody UserRoleDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty(entity.getUserId())) {
            return Response.createError(ResponseCode.USER_UUID_NOT_NULL.getMsg(),
                    ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(entity.getApplicationId(), entity.getTenantNo());
        return Response.createSuccess(roleService.queryRoleByUserId(entity));
    }

    @PostMapping("/queryRoleByName")
    @ApiOperation(value = "通过角色名称查询角色信息", notes = "通过角色名称查询角色信息")
    public Response<List<RoleSimpleDTO>> queryRoleByName(@RequestBody RoleDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty(entity.getRoleName())) {
            return Response.createError(ResponseCode.ROLE_NAME_NOT_NULL.getMsg(),
                    ResponseCode.ROLE_NAME_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(entity.getApplicationId(), entity.getTenantNo());
        return Response.createSuccess(roleService.queryRoleByName(entity));
    }

    /**
     * 冻结数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    @PostMapping("/frozen")
    @ApiOperation(value = "冻结", notes = "冻结")
    public Response frozen(@RequestBody RoleDTO bean) {
        if (CuscStringUtils.isEmpty(bean.getUuid())) {
            return Response.createError(ResponseCode.ROLE_UUID_NOT_NULL.getMsg(),
                    ResponseCode.ROLE_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(bean.getApplicationId(), bean.getTenantNo());
        RoleDTO ret = roleService.frozen(bean);
        urlService.roleRelUrlToRedis(ret.getUuid(), ret.getRoleScene(), ret.getTenantNo(), ret.getApplicationId());
        return Response.createSuccess(true);
    }

    /**
     * 解冻数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    @PostMapping("/unfreeze")
    @ApiOperation(value = "解冻", notes = "解冻")
    public Response unfreeze(@RequestBody RoleDTO bean) {
        if (CuscStringUtils.isEmpty(bean.getUuid())) {
            return Response.createError(ResponseCode.ROLE_UUID_NOT_NULL.getMsg(),
                    ResponseCode.ROLE_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(bean.getApplicationId(), bean.getTenantNo());
        RoleDTO ret = roleService.unfreeze(bean);
        urlService.roleRelUrlToRedis(ret.getUuid(), ret.getRoleScene(), ret.getTenantNo(), ret.getApplicationId());
        return Response.createSuccess(true);
    }

    @PostMapping("/queryHideSensitiveByUserId")
    @ApiOperation(value = "通过用户id查询是否脱敏", notes = "通过用户id查询是否脱敏   false 脱敏，  true 不脱敏")
    public Response<Boolean> queryHideSensitiveByUserId(@RequestBody UserRoleDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty(entity.getUserId())) {
            return Response.createError(ResponseCode.USER_UUID_NOT_NULL.getMsg(),
                    ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired(entity.getApplicationId(), entity.getTenantNo());
        return roleService.queryHideSensitiveByUserId(entity);
    }
}
