package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.ResourceTempalteDTO;
import com.cusc.nirvana.user.eiam.service.IResourceTempalteService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * (ResourceTempalte)表控制层
 *
 * @author yuy336
 * @since 2022-01-11 17:34:39
 */
@RestController
@RequestMapping("/resourceTempalte")
public class ResourceTempalteController {
    /**
     * 服务对象
     */
    @Autowired
    private IResourceTempalteService resourceTempalteService;

    /**
     * 分页查询
     *
     * @param resourceTempalte 筛选条件
     * @return 查询结果
     */
    @PostMapping("/queryByPage")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    public Response<PageResult<ResourceTempalteDTO>> queryByPage(@RequestBody ResourceTempalteDTO resourceTempalte) {
        return Response.createSuccess(resourceTempalteService.queryByPage(resourceTempalte));
    }

    /**
     * 通过主键查询单条数据
     *
     * @param resourceTempalte 实体
     * @return 单条数据
     */
   @PostMapping("/getByUuid")
    public Response<ResourceTempalteDTO> getByUuid(@RequestBody ResourceTempalteDTO resourceTempalte) {
        return Response.createSuccess(this.resourceTempalteService.getByUuid(resourceTempalte));
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param resourceTempalte 实体
     * @return 单条数据
     */
   @PostMapping("/queryByList")
    public Response<List<ResourceTempalteDTO>> queryByList(@RequestBody ResourceTempalteDTO resourceTempalte) {
        return Response.createSuccess(this.resourceTempalteService.queryByList(resourceTempalte));
    }

    /**
     * 新增数据
     *
     * @param resourceTempalte 实体
     * @return 新增结果
     */
    @PostMapping("/add")
    public Response add(@RequestBody ResourceTempalteDTO resourceTempalte) {
       this.resourceTempalteService.insert(resourceTempalte);
       return Response.createSuccess();
    }

    /**
     * 编辑数据
     *
     * @param resourceTempalte 实体
     * @return 编辑结果
     */
    @PostMapping("/update")
    public Response update(@RequestBody ResourceTempalteDTO resourceTempalte) {
        this.resourceTempalteService.update(resourceTempalte);
        return Response.createSuccess();
    }

    /**
     * 删除数据
     *
     * @param resourceTempalte 实体
     * @return 删除是否成功
     */
    @PostMapping("/deleteById")
    public Response<Boolean> deleteById(@RequestBody ResourceTempalteDTO resourceTempalte) {
        return Response.createSuccess(resourceTempalteService.deleteById(resourceTempalte));
    }

    /**
     *  通过租户编号和应用id查询资源id集合
     * @param resourceTempalte
     * @return
     */
    @PostMapping("/queryResourceIdList")
    public Response<List<String>> queryResourceIdList(@RequestBody ResourceTempalteDTO resourceTempalte) {
        if(CuscStringUtils.isEmpty(resourceTempalte.getApplicationId()) || CuscStringUtils.isEmpty(resourceTempalte.getRoleCode())){
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(resourceTempalteService.queryResourceIdList(resourceTempalte));
    }

}

