package com.cusc.nirvana.user.eiam.constants;

public enum ResponseCode {
    INVALID_DATA(1001, "数据校验不通过"),
    SYS_BUSY(1002, "服务调用失败"),
    SERVICE_NOT_FOUND(1003, "服务不存在"),
    TP_SYS_BUSY(1004, "第三方服务调用失败"),
    JSON_FORMAT_ERROR(1005, "参数格式错误"),
    REQ_TOO_MANY_TIMES(1007, "请求过于频繁，请联系管理员!"),
    NO_DATA_AUTH(1008, "请求过于频繁，请联系管理员!"),
    REDIS_OPT_FAIL(1009, "redis操作失败，请联系管理员！"),
    PARAMETER_NULL(1010, "请求参数不能为空！"),

    SMS_GET_CAPTCHA_FAIL(1113, "获取短信验证码失败"),
    SMS_CAPTCHA_INVALID(1114, "短信验证码无效！"),


    TENANT_NO_GENERATE_FAIL(1501, "租户编码生成失败"),
    COMPANY_REPEAT(1502, "公司名称重复"),
    USER_NAME_REPEAT(1503, "登录名重复"),
    USER_PHONE_REPEAT(1504, "手机号重复"),
    USER_EMAIL_REPEAT(1505, "邮箱重复"),
    USER_PASSWORD_NOT_NULL(1506, "用户密码不能为空"),
    ROLE_NAME_REPEAT(1507, "该角色名称已存在！"),
    ROLE_UUID_NOT_NULL(1508, "角色uuid不能为空"),
    ROLE_NAME_NOT_NULL(1509, "角色名称不能为空"),
    TENANT_NO_NOT_NULL(1510, "租户编码不能为空"),
    COMPANY_UUID_NOT_NULL(1511, "公司uuid不能为空"),
    USER_PHONE_NOT_NULL(1512, "用户手机号不能为空"),
    USER_UUID_NOT_NULL(1513, "用户uuid不能为空"),
    USER_ID_NOT_NULL(1514, "用户id不能为空"),
    ROLE_INVALID(1515, "无效的角色信息"),
    USER_INVALID(1516, "无效的用户信息"),
    TENANT_ADMIN_INVALID(1517, "租户的管理员账号不存在，请联系系统管理员！"),
    APP_CODE_NOT_NULL(1518, "应用编码不能为空"),
    APP_CONFIG_INVALID(1519, "应用配置信息无效"),
    USER_OLD_PASSWORD_ERROR(1520, "用户原密码不正确"),
    SMS_CONFIG_NOT_NULL(1521, "短信配置不能为空"),
    RESET_PASSWORDPHONE_NOT_NULL(1522, "重置密码失败，手机号不能空"),
    SMS_SEND_ERROR(1523, "短信发送失败，内部错误"),
    SMS_TOTAL_LIMIT_OVERRUN(1524, "发送短信超过当天发送的最大限制"),
    SMS_INTERVAL_LIMIT_OVERRUN(1525, "短信发送失败，发送间隔限制时间内重复发送"),
    APPLICATION_TENANT_REQUIRED(1526,"应用id和租户编号不能为空"),
    KICK_OUT_FAIL(1527,"踢出失败，系统异常！"),
    USER_NAME_NOT_NULL(1528, "用户名不能为空"),
    USER_EMAIL_NOT_NULL(1529, "邮箱不能为空"),
    RESOURCE_INVALID(1530, "无效的资源信息"),
    TENANT_NAME_REPEART(1531, "租户名称重复"),
    ORGAN_PARENT_INVALID(1532, "组织父节点无效"),

	SYSTEM_ERROR(-1, "系统错误");
    ;

    private Integer code;
    private String msg;

    ResponseCode(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
