package com.cusc.nirvana.user.eiam.constants;

public enum PasswordCheckCode {
   PASSWORD_LENGTH(1601,"密码长度限制为8-20个字符"),
    CONTAINS_USER_NAME(1602,"密码不能包含用户名"),
    CONTINUOUS_CHARACTER(1603,"密码不能包含3个连续的字符"),
    KEYBOARD_CONTINUOUS_CHARACTERS(1604,"密码不能包含3个及以上键盘连续字符"),
    CONTAINS_SYSTEM_PASSWORD(1605,"密码不能使用操作系统、数据库等相关词组"),
    TOO_LOW_COMPLEXITY(1606,"数字、小写字母、大写字母、特殊字符，至少包含三种")
    ;

    private Integer code;
    private String msg;

    PasswordCheckCode(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
