package com.cusc.nirvana.user.config;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.exception.CuscUserException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(0)
public class RnrUserExceptionHandler {

    private static final Logger log = LoggerFactory.getLogger(RnrUserExceptionHandler.class);

    @ExceptionHandler(CuscUserException.class)
    @ResponseStatus(HttpStatus.OK)
    public Response excpetionHandler(CuscUserException e) {
        log.warn("CuscUserException Handler:code {}, description: {}", e.getCode(), e.getMessage());
		return Response.createError(e.getMessage(), StringUtils.isBlank(e.getCode()) ? ResponseCode.SYSTEM_ERROR.getCode() : Integer.parseInt(e.getCode()));
    }
}
