package com.cusc.nirvana.user.ciam.util.crypt;

import com.cusc.nirvana.user.util.crypt.CryptKeyUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Base64;

public class SM4GCMUtils {

    static {
        Security.addProvider(new BouncyCastleProvider()); // 注册 Bouncy Castle
    }

    /**
     * 生成 SM4 密钥（128-bit）
     */
    public static byte[] generateSM4Key() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("SM4", "BC");
        keyGenerator.init(128); // SM4 密钥长度固定 128-bit
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    /**
     * SM4-GCM 加密（返回 Base64 字符串）
     */
    public static String encrypt(String plaintext, byte[] key, byte[] iv, byte[] aad) throws Exception {
        Cipher cipher = Cipher.getInstance("SM4/GCM/NoPadding", "BC");
        SecretKeySpec keySpec = new SecretKeySpec(key, "SM4");
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
        cipher.init(Cipher.ENCRYPT_MODE, keySpec, gcmSpec);
        if (aad != null) {
            cipher.updateAAD(aad); // 可选：附加认证数据
        }
        byte[] encryptedBytes = cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    /**
     * SM4-GCM 解密（输入 Base64 字符串）
     */
    public static String decrypt(String ciphertextBase64, byte[] key, byte[] iv, byte[] aad) throws Exception {
        Cipher cipher = Cipher.getInstance("SM4/GCM/NoPadding", "BC");
        SecretKeySpec keySpec = new SecretKeySpec(key, "SM4");
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
        cipher.init(Cipher.DECRYPT_MODE, keySpec, gcmSpec);
        if (aad != null) {
            cipher.updateAAD(aad);
        }
        byte[] ciphertextBytes = Base64.getDecoder().decode(ciphertextBase64);
        byte[] decryptedBytes = cipher.doFinal(ciphertextBytes);
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }

    /**
     * 生成随机 IV（推荐 12 字节）
     */
    public static byte[] generateIV() {
        byte[] iv = new byte[12]; // GCM 推荐 12-byte IV
        new SecureRandom().nextBytes(iv);
        return iv;
    }

    public static void main(String[] args) throws Exception {
        // 1. 生成 SM4 密钥
//        byte[] key = generateSM4Key();
//        System.out.println("SM4 Key (Base64): " + Base64.getEncoder().encodeToString(key));
        byte[] key = "rqtUv7m@kEBVXJ2w".getBytes(StandardCharsets.UTF_8);

        // 2. 生成随机 IV
//        byte[] iv = generateIV();
        byte[] iv = "LzjmtwgvjdMUG+jl".getBytes(StandardCharsets.UTF_8);
        System.out.println("IV (Base64): " + Base64.getEncoder().encodeToString(iv));
        System.out.println("IV (Base64): " + new String(iv, StandardCharsets.UTF_8));

        // 3. 可选 AAD（附加认证数据）
        byte[] aad = "AdditionalAuthData".getBytes(StandardCharsets.UTF_8);

        String plaintext = "Hello, SM4-GCM 加密测试！";

        // 4. 加密
        String encryptedText = encrypt(plaintext, key, iv, aad);
        System.out.println("加密结果 (Base64): " + encryptedText);

        // 5. 解密
        String decryptedText = decrypt(encryptedText, key, iv, aad);
        System.out.println("解密结果: " + decryptedText);

        String plaintext2 = "Hello, SM4-GCM 加密测试！";
        String encryptedText2 = encrypt(plaintext2, key, iv, aad);
        System.out.println("加密结果2 (Base64): " + encryptedText2);
    }

}