package com.cusc.nirvana.user.ciam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.user.ciam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.ciam.converter.UserThirdpartyConverter;
import com.cusc.nirvana.user.ciam.dao.UserThirdpartyDao;
import com.cusc.nirvana.user.ciam.dao.entity.UserThirdpartyPO;
import com.cusc.nirvana.user.ciam.dto.CiamUserThirdpartyDTO;
import com.cusc.nirvana.user.ciam.service.IUserThirdpartyService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 终端用户三方认证(UserThirdparty)表服务实现类
 *
 * @author yuy336
 * @since 2022-05-05 19:54:47
 */
@Service
public class UserThirdpartyServiceImpl extends ServiceImpl<UserThirdpartyDao, UserThirdpartyPO> implements IUserThirdpartyService {

    /**
     * 通过UUID查询单条数据
     *
     * @param bean
     * @return 实例对象
     */
    @Override
    public CiamUserThirdpartyDTO getByUuid(CiamUserThirdpartyDTO bean) {
        UserThirdpartyPO record = this.getPoByUuid(bean.getUuid());;
        return UserThirdpartyConverter.INSTANCE.poToDto(record);
    }

    /**
     * 通过查询条件查询集合数据
     *
     * @param bean
     * @return 集合对象
     */
    @Override
    public List<CiamUserThirdpartyDTO> queryByList(CiamUserThirdpartyDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc("create_time");
        List<UserThirdpartyPO> record = this.list(queryWrapper);
        return UserThirdpartyConverter.INSTANCE.poListToDtoList(record);
    }

    /**
     * 新增数据
     *
     * @param bean 实例对象
     * @return 实例对象
     */
    @Override
    @Transactional
    public CiamUserThirdpartyDTO insert(CiamUserThirdpartyDTO bean) {
        UserThirdpartyPO userThirdpartyPO = UserThirdpartyConverter.INSTANCE.dtoToPo(bean);
        userThirdpartyPO.setUuid(CuscStringUtils.generateUuid());
        this.save(userThirdpartyPO);
        bean.setUuid(userThirdpartyPO.getUuid());
        return bean;
    }

    /**
     * 修改数据
     *
     * @param bean 实例对象
     * @return 实例对象
     */
    @Override
    @Transactional
    public CiamUserThirdpartyDTO update(CiamUserThirdpartyDTO bean) {
        UserThirdpartyPO userThirdpartyPO = this.getPoByUuid(bean.getUuid());
        if(userThirdpartyPO == null){
            return null;
        }
        UserThirdpartyPO tmpBean = UserThirdpartyConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(userThirdpartyPO.getId());
        this.updateById(tmpBean);
        return bean;
    }

    /**
     * 通过主键删除数据
     * @param bean 实例对象
     * @return 是否成功
     */
    @Override
    @Transactional
    public boolean deleteById(CiamUserThirdpartyDTO bean) {
        UserThirdpartyPO userThirdpartyPO = this.getPoByUuid(bean.getUuid());
        if (userThirdpartyPO == null) {
            return false;
        }
        UserThirdpartyPO tmpBean = new UserThirdpartyPO();
        tmpBean.setId(userThirdpartyPO.getId());
        tmpBean.setIsDelete(CommonDeleteEnum.DELETED.getCode());
        return this.updateById(tmpBean);
    }

    /**
     * 通过UUID查询单条数据
     *
     * @param uuid
     * @return 实例对象
     */
    private UserThirdpartyPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("uuid", uuid);
        queryWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        return this.getOne(queryWrapper);
    }
}
