package com.cusc.nirvana.user.ciam.controller;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.ciam.dto.CiamUserDTO;
import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.crypt.CryptKeyUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/crypt")
public class CryptController {


    @PostMapping("/encrypt")
    public Response encrypt(@RequestBody CiamUserDTO bean) {
        Map<String, String> ret = new HashMap<>();
        if (CuscStringUtils.isNotEmpty(bean.getPhoneNum())) {
            ret.put("phone", CryptKeyUtil.encryptToBase64(bean.getPhoneNum()));
        }
        return Response.createSuccess(ret);
    }

    @PostMapping("/decrypt")
    public Response decrypt(@RequestBody CiamUserDTO bean) {
        Map<String, String> ret = new HashMap<>();
        if (CuscStringUtils.isNotEmpty(bean.getPhoneNum())) {
            ret.put("phone", CryptKeyUtil.decryptByBase64(bean.getPhoneNum()));
        }
        return Response.createSuccess(ret);
    }

}
