package com.cusc.nirvana.user.auth.identification.service;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.dto.LogoutDTO;
import com.cusc.nirvana.user.auth.identification.dto.MobileLoginReq;
import com.cusc.nirvana.user.auth.identification.dto.Oauth2Token;
import com.cusc.nirvana.user.auth.identification.dto.UserNameLoginReq;
import com.cusc.nirvana.user.eiam.dto.UserDTO;

/**
 * Description: 令牌service
 * <br />
 * CreateDate 2021-11-02 20:25:19
 *
 * @author yuyi
 **/
public interface ITokenService {

    /**
     * Description: 创建Oauth2Token(手机号)
     * <br />
     * CreateDate 2021-11-04 19:53:41
     *
     * @author yuyi
     **/
    Response<Oauth2Token> createOauth2TokenByMobile(MobileLoginReq bean, UserDTO user);


    /**
     * Description: 创建Oauth2Token(手机号)小鹏
     * <br />
     * CreateDate 2021-11-04 19:53:41
     *
     * @author yuyi
     **/
    Response<Oauth2Token> createOauth2TokenByMobileXP(MobileLoginReq bean, UserDTO user);

    /**
     * Description: 创建Oauth2Token(登录名)
     * <br />
     * CreateDate 2021-11-04 19:53:41
     *
     * @author yuyi
     **/
    Response<Oauth2Token> createOauth2TokenByUserName(UserNameLoginReq bean, UserDTO user);

    /**
     * Description: 创建Oauth2Token
     * <br />
     * CreateDate 2021-11-04 19:53:41
     *
     * @author yuyi
     **/
    Response logout(LogoutDTO logoutDTO);

    /**
     * Description: 通过用户id踢出
     * <br />
     * CreateDate 2021-11-04 19:53:41
     *
     * @author yuyi
     **/
    Response kickOutByUserId(String userId, String tenantNo, String appId);

    /**
     * Description: access token续期
     * <br />
     * CreateDate 2021-11-04 19:53:41
     *
     * @author yuyi
     **/
    Response tokenRenewal(String accessToken, String appId);
}
