package com.cusc.nirvana.user.auth.identification.service;

/**
 * Description: 随机id或随机数业务层
 * <br />
 * CreateDate 2021-11-02 20:25:19
 *
 * @author yuyi
 **/
public interface IRandomIdService {

    /**
     * Description: 生成请求id并存放至redis
     * <br />
     * CreateDate 2022-01-24 10:32:21
     *
     * @param expireTime redis失效时间，单位：秒。必填
     * @param content    redis存放的内容
     * @author yuyi
     **/
    String getRequestIdToRedis(String applicationId, int expireTime, String content);

    /**
     * Description: 判断请求id是否存在
     * <br />
     * CreateDate 2022-01-24 10:32:21
     *
     * @param requestId 请求id
     * @author yuyi
     **/
    boolean existsRequestIdRedis(String requestId, String applicationId);

    /**
     * Description: 删除redis中的请求id
     * <br />
     * CreateDate 2022-01-24 10:32:21
     *
     * @param requestId 请求id
     * @author yuyi
     **/
    boolean delRequestIdRedis(String requestId, String applicationId);

    /**
     * Description: 通过请求id获取请求的内容
     * <br />
     * CreateDate 2022-01-24 10:32:21
     *
     * @param requestId 请求id，必填
     * @author yuyi
     **/
    String getByRequestId(String requestId, String applicationId);
}
