package com.cusc.nirvana.user.auth.identification.login;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.common.dto.LogoutDTO;
import com.cusc.nirvana.user.auth.identification.service.ITokenService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
public class LogoutController {

    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutController.class);

    @Autowired
    ITokenService tokenService;

    @PostMapping("/logout")
    @ApiOperation(value = "退出", notes = "退出")
    public Response logout(@RequestBody LogoutDTO logoutDTO) {
        if (logoutDTO == null || CuscStringUtils.isEmpty(logoutDTO.getAccessToken()) || CuscStringUtils.isEmpty(logoutDTO.getApplicationId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(), ResponseCode.PARAMETER_NULL.getCode());
        }
        return tokenService.logout(logoutDTO);
    }

}
