package com.cusc.nirvana.user.auth.common.constants;

/**
 * Description: redis相关常量类
 * <br />
 * CreateDate 2021-11-03 20:36
 *
 * @author yuyi
 **/
public class RedisConstant {

    //短信验证码key前缀
    public static final String SMS_CAPTCHA_KEY = "CT:USER:AUTH:SMS:CAPTCHA:";

    //短信验证码错误次数key前缀
    public static final String SMS_CAPTCHA_ERROR_COUNT_KEY = "CT:USER:AUTH:SMS:CAPTCHA:ERROR_COUNT:";

    //短信验证码错误次数key默认失效时间（秒）
    public static final int SMS_CAPTCHA_ERROR_COUNT_EXPIRE = 3600;

    //短信验证码发送间隔key前缀
    public static final String SMS_CAPTCHA_SEND_INTERVAL_KEY = "CT:USER:AUTH:SMS:INTERVAL:CAPTCHA:";

    //短信验证码发送天限制key前缀
    public static final String SMS_CAPTCHA_SEND_TOTAL_KEY = "CT:USER:AUTH:SMS:DAY:CAPTCHA:";

    //短信验证码key默认失效时间（秒）
    public static final int SMS_CAPTCHA_EXPIRE = 1800;

    //access_token对应的用户id、refresh_token、scope
    public static final String TOKEN_ACCESS_TOKEN_INFO = "CT:USER:AUTH:TOKEN:ACCESS_TOKEN:";

    //refresh_token对应的token和用户id
    public static final String TOKEN_REFRESH_TOKEN_INFO = "CT:USER:AUTH:TOKEN:REFRESH_TOKEN:";

    //用户id对应的access_token、refresh_token集合
    public static final String TOKEN_USER_TOKEN_INFO = "CT:USER:AUTH:TOKEN:USER:";

    //随机请求id redis key
    public static final String RANDOM_REQUEST_ID = "CT:USER:AUTH:RANDOM:ID:";

    //图形验证码 redis key
    public static final String IMAGE_CAPTCHA_KEY = "CT:USER:AUTH:CAPTCHA:IMAGE:";

    //账号密码错误次数 redis key
    public static final String USERNAME_PASSWORD_FAIL_COUNT_KEY = "CT:USER:AUTH:USERNAME:PASSWORD_COUNT:";

    //账号锁定 redis key
    public static final String USERNAME_LOCK_KEY = "CT:USER:AUTH:USERNAME:LOCK:";

    //-------------------鉴权相关------------------------
    //url的白名单集合
    public static final String URL_WHITE_LIST = "CT:USER:AUTH:URL:WHITE:LIST";

    //角色对应的URL集合信息
    public static final String ROLE_URL_LIST = "CT:USER:AUTH:URL:ROLE:";

    //用户对应的角色id集合信息
    public static final String USER_ROLE_ID_LIST = "CT:USER:AUTH:USER:ROLE:";

    //应用与url的分隔符
    public static final String APPID_URL_SEPARATOR = "-";

    //token
    public static final int TOKEN_RENEWAL_EXPIRES_IN = 1800;

    //用户id对应的url集合 CT:USER:AUTH:URL:USER:租户编号:用户id_应用id
    public static final String USER_URL_LIST = "CT:USER:AUTH:URL:USER:";
}
