package com.cusc.nirvana.user.auth.authentication.service;

import com.cache.CacheFactory;
import com.cache.constants.CacheConstants;
import com.cache.exception.CacheException;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.constants.RedisConstant;
import com.cusc.nirvana.user.auth.common.dto.AccessTokenHashDTO;
import com.cusc.nirvana.user.auth.common.service.AppConfigService;
import com.cusc.nirvana.user.eiam.dto.ApplicationDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * Description: 令牌service实现类
 * <br />
 * CreateDate 2021-11-02 20:25:49
 *
 * @author yuyi
 **/
@Service
@Slf4j
public class TokenService {

    @Autowired
    private CacheFactory cacheFactory;

    @Autowired
    private AppConfigService appConfigService;

    /**
     * Description: token续期
     * <br />
     * CreateDate 2021-12-03 20:10:46
     *
     * @author yuyi
     **/
    @Async("dataToRedisExecutor")
    public void tokenRenewal(Response<AccessTokenHashDTO> ckTokenResp, String accessToken) {
        if (ckTokenResp == null || !ckTokenResp.isSuccess() || ckTokenResp.getData() == null) {
            return;
        }
        AccessTokenHashDTO tokenInfo = ckTokenResp.getData();
        ApplicationDTO appBean = appConfigService.getAppConfigByCode(tokenInfo.getAppId());
        try {
            cacheFactory.getExpireHashService()
                    .expireKey(RedisConstant.TOKEN_REFRESH_TOKEN_INFO + accessToken, appBean.getRenewalTokenTime(),
                            CacheConstants.TimeType.EX);
            //同时续期用户id对应的token信息
            AccessTokenHashDTO accessTokenHashDTO = cacheFactory.getExpireHashService()
                    .getHash(RedisConstant.TOKEN_ACCESS_TOKEN_INFO + accessToken,
                            AccessTokenHashDTO.class);
            if (accessTokenHashDTO != null) {
                cacheFactory.getExpireListService()
                        .updateExpire(RedisConstant.TOKEN_USER_TOKEN_INFO + accessTokenHashDTO.getTenantNo() + ":" + accessTokenHashDTO.getUserId(),
                                appBean.getRenewalTokenTime());
            }
        } catch (CacheException e) {
            log.error("tokenRenewal 访问reids失败 key:" + RedisConstant.TOKEN_ACCESS_TOKEN_INFO + accessToken + " 异常:{}",
                    e);
        }
    }
}
