package com.cusc.nirvana.user;

import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;

/**
* UserEiamApplication
*
* 1、使用generator生产骨架工程代码;
*
* 2、到nacos创建配置信息,默认集成nacos作为: 配置中心, 注册中心
*   - nacos-url: http://172.24.120.141:8848/nacos/
*   - nacos-user: cusc
*   - nacos-password: cusc@nacos
*   - 2.1、注意选择环境,环境不要选择错误
*   - 2.2、Data-ID必须与项目名称相同,即：{spring.application.name}或者{spring.application.name}-yml
*   - 2.3、Group使用默认
*   - 2.4、配置文件类型必须选择"yaml(yml)"
*
* 3、本地测试启动是需要添加启动参数: VM options: -Denv=local -Dspring.profiles.active=local
*   - 3.1、非本地调试环境由各环境启动脚本配置
*
* @author auto-generator
* @since 2021-10-20
*/
@Slf4j
@SpringBootApplication
@MapperScan({"com.cusc.nirvana.**.dao"})
@ComponentScan({"com.cusc", "com.cache.*"})
@EnableDiscoveryClient
public class LocalRnrUserApplication {

    public static void main(String[] args) {
        try {
            ApplicationContext context = SpringApplication.run(LocalRnrUserApplication.class, args);
            String serverPort = context.getEnvironment().getProperty("server.port");
            log.info("启动成功! Swagger2: http://127.0.0.1:" + serverPort + "/swagger-ui.html");
        } catch (Exception ex) {
            log.error("", ex);
        }
    }

}
