/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.constants.CommonStatusEnum;
import com.cusc.nirvana.user.eiam.constants.CommonYesOrNoEnum;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.converter.UserConverter;
import com.cusc.nirvana.user.eiam.dao.UserDao;
import com.cusc.nirvana.user.eiam.dao.entity.UserPO;
import com.cusc.nirvana.user.eiam.dto.ApplicationDTO;
import com.cusc.nirvana.user.eiam.dto.SmsSendConfig;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.eiam.dto.UserPasswordDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.dto.UserSimpleDTO;
import com.cusc.nirvana.user.eiam.dto.UserTokenListDTO;
import com.cusc.nirvana.user.eiam.service.IApplicationService;
import com.cusc.nirvana.user.eiam.service.IEiamSmsService;
import com.cusc.nirvana.user.eiam.service.IUrlService;
import com.cusc.nirvana.user.eiam.service.IUserRoleService;
import com.cusc.nirvana.user.eiam.service.IUserService;
import com.cusc.nirvana.user.eiam.service.impl.EiamTokenService;
import com.cusc.nirvana.user.eiam.util.PasswordChecker;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.crypt.Sm4Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UserServiceImpl
extends ServiceImpl<UserDao, UserPO>
implements IUserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private IUserRoleService userRoleService;
    @Autowired
    private IEiamSmsService smsService;
    @Autowired
    @Lazy
    private IUrlService urlService;
    @Autowired
    private IApplicationService applicationService;
    @Autowired
    private EiamTokenService tokenService;
    @Autowired
    private CacheFactory cacheFactory;

    @Transactional
    public UserDTO addUser(UserDTO entity) {
        List checkUserList;
        UserDTO checkUserRepeat;
        UserPO entity0 = new UserPO();
        BeanUtils.copyProperties((Object)entity, (Object)entity0);
        entity0.setUuid(CuscStringUtils.generateUuid());
        entity0.setStatus(Integer.valueOf(CommonStatusEnum.ENABLE.getCode()));
        if (CuscStringUtils.isNotEmpty((String)entity.getPassword())) {
            PasswordChecker.checkPasswordRule((String)entity.getPassword(), (String)entity.getUserName(), (String)entity.getPhone(), (String)entity.getEmail());
            entity0.setPassword(Sm4Util.encryptEcbPadding((String)entity0.getUuid().substring(16), (String)entity.getPassword()));
        }
        if (CuscStringUtils.isNotEmpty((String)entity.getUserName())) {
            checkUserRepeat = new UserDTO();
            checkUserRepeat.setUserName(entity.getUserName());
            checkUserRepeat.setTenantNo(entity.getTenantNo());
            checkUserList = this.queryUserByParams(checkUserRepeat);
            if (!CollectionUtils.isEmpty((Collection)checkUserList)) {
                throw new CuscUserException(ResponseCode.USER_NAME_REPEAT.getCode(), ResponseCode.USER_NAME_REPEAT.getMsg());
            }
        }
        if (CuscStringUtils.isNotEmpty((String)entity.getPhone())) {
            checkUserRepeat = new UserDTO();
            checkUserRepeat.setPhone(entity.getPhone());
            checkUserRepeat.setTenantNo(entity.getTenantNo());
            checkUserList = this.queryUserByParams(checkUserRepeat);
            if (!CollectionUtils.isEmpty((Collection)checkUserList)) {
                throw new CuscUserException(ResponseCode.USER_PHONE_REPEAT.getCode(), ResponseCode.USER_PHONE_REPEAT.getMsg());
            }
        }
        if (CuscStringUtils.isNotEmpty((String)entity.getEmail())) {
            checkUserRepeat = new UserDTO();
            checkUserRepeat.setEmail(entity.getEmail());
            checkUserRepeat.setTenantNo(entity.getTenantNo());
            checkUserList = this.queryUserByParams(checkUserRepeat);
            if (!CollectionUtils.isEmpty((Collection)checkUserList)) {
                throw new CuscUserException(ResponseCode.USER_EMAIL_REPEAT.getCode(), ResponseCode.USER_EMAIL_REPEAT.getMsg());
            }
        }
        this.save((Object)entity0);
        entity.setUuid(entity0.getUuid());
        return entity;
    }

    @Transactional
    public UserDTO updateUser(UserDTO entity) {
        List checkUserList;
        UserDTO checkUserRepeat;
        UserPO entity0 = this.getPoByUuid(entity.getUuid(), entity.getTenantNo());
        if (entity0 == null || CommonDeleteEnum.DELETED.getCode() == entity0.getIsDelete().intValue()) {
            throw new CuscUserException(ResponseCode.USER_INVALID.getCode(), ResponseCode.USER_INVALID.getMsg());
        }
        entity.setId(entity0.getId());
        BeanUtils.copyProperties((Object)entity, (Object)entity0);
        if (CuscStringUtils.isNotEmpty((String)entity.getUserName())) {
            checkUserRepeat = new UserDTO();
            checkUserRepeat.setUserName(entity.getUserName());
            checkUserRepeat.setId(entity.getId());
            checkUserRepeat.setTenantNo(entity.getTenantNo());
            checkUserList = this.queryUserByParams(checkUserRepeat);
            if (!CollectionUtils.isEmpty((Collection)checkUserList)) {
                throw new CuscUserException(ResponseCode.USER_NAME_REPEAT.getCode(), ResponseCode.USER_NAME_REPEAT.getMsg());
            }
        }
        if (CuscStringUtils.isNotEmpty((String)entity.getPhone())) {
            checkUserRepeat = new UserDTO();
            checkUserRepeat.setPhone(entity.getPhone());
            checkUserRepeat.setId(entity.getId());
            checkUserRepeat.setTenantNo(entity.getTenantNo());
            checkUserList = this.queryUserByParams(checkUserRepeat);
            if (!CollectionUtils.isEmpty((Collection)checkUserList)) {
                throw new CuscUserException(ResponseCode.USER_PHONE_REPEAT.getCode(), ResponseCode.USER_PHONE_REPEAT.getMsg());
            }
        }
        if (CuscStringUtils.isNotEmpty((String)entity.getEmail())) {
            checkUserRepeat = new UserDTO();
            checkUserRepeat.setEmail(entity.getEmail());
            checkUserRepeat.setId(entity.getId());
            checkUserRepeat.setTenantNo(entity.getTenantNo());
            checkUserList = this.queryUserByParams(checkUserRepeat);
            if (!CollectionUtils.isEmpty((Collection)checkUserList)) {
                throw new CuscUserException(ResponseCode.USER_EMAIL_REPEAT.getCode(), ResponseCode.USER_EMAIL_REPEAT.getMsg());
            }
        }
        entity0.setUuid(null);
        entity0.setPassword(null);
        entity0.setTenantNo(null);
        this.updateById((Object)entity0);
        return entity;
    }

    @Transactional
    public boolean deleteUser(UserDTO entity) {
        UserPO entity0 = this.getPoByUuid(entity.getUuid(), entity.getTenantNo());
        if (entity0 == null) {
            throw new CuscUserException(ResponseCode.USER_INVALID.getCode(), ResponseCode.USER_INVALID.getMsg());
        }
        entity.setId(entity0.getId());
        String userId = entity0.getUuid();
        if (CommonDeleteEnum.DELETED.getCode() == entity0.getIsDelete().intValue()) {
            return true;
        }
        UserRoleDTO userRole = new UserRoleDTO();
        userRole.setUserId(entity0.getUuid());
        this.userRoleService.deleteByUser(userRole);
        entity0 = new UserPO();
        entity0.setId(entity.getId());
        entity0.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        entity0.setStatus(Integer.valueOf(CommonStatusEnum.DISABLE.getCode()));
        boolean ret = this.updateById((Object)entity0);
        this.urlService.delUserRelUrlRedis(userId, entity0.getTenantNo(), null);
        this.tokenService.kickOutByUserId(userId, entity.getTenantNo());
        return ret;
    }

    public UserDTO getUser(UserDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(entity.getId() != null, (Object)"id", (Object)entity.getId());
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"tenant_no", (Object)entity.getTenantNo());
        queryWrapper.in(!CollectionUtils.isEmpty((Collection)entity.getTenantNoList()), (Object)"tenant_no", (Collection)entity.getTenantNoList());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getPhone()), (Object)"phone", (Object)entity.getPhone());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getEmail()), (Object)"email", (Object)entity.getEmail());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getUserName()), (Object)"user_name", (Object)entity.getUserName());
        queryWrapper.eq(entity.getIsTenantAdmin() != null, (Object)"is_tenant_admin", (Object)entity.getIsTenantAdmin());
        queryWrapper.eq(entity.getStatus() != null, (Object)"status", (Object)entity.getStatus());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getUuid()), (Object)"uuid", (Object)entity.getUuid());
        UserPO record = (UserPO)this.getOne((Wrapper)queryWrapper);
        return UserConverter.INSTANCE.poToDto(record);
    }

    public PageResult<UserDTO> pageListUser(UserDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.eq((Object)"tenant_no", (Object)entity.getTenantNo());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)entity.getUserName()), (Object)"user_name", (Object)entity.getUserName());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)entity.getPhone()), (Object)"phone", (Object)entity.getPhone());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)entity.getFullName()), (Object)"full_name", (Object)entity.getFullName());
        queryWrapper.eq(entity.getStatus() != null, (Object)"status", (Object)entity.getStatus());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getUuid()), (Object)"uuid", (Object)entity.getUuid());
        queryWrapper.eq(entity.getId() != null, (Object)"id", (Object)entity.getId());
        if (CuscStringUtils.isNotEmpty((String)entity.getQueryOrganId())) {
            queryWrapper.exists("select user_id from eiam_user_organ where eiam_user.uuid = eiam_user_organ.user_id and eiam_user_organ.organ_id = '" + entity.getQueryOrganId() + "'");
        }
        Page page = (Page)this.page((IPage)new Page((long)entity.getCurrPage().intValue(), (long)entity.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, UserDTO.class);
    }

    public List<UserSimpleDTO> queryListUser(UserDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getTenantNo()), (Object)"tenant_no", (Object)entity.getTenantNo());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getUserName()), (Object)"user_name", (Object)entity.getUserName());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getPhone()), (Object)"phone", (Object)entity.getPhone());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)entity.getFullName()), (Object)"full_name", (Object)entity.getFullName());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getUuid()), (Object)"uuid", (Object)entity.getUuid());
        queryWrapper.in(!CollectionUtils.isEmpty((Collection)entity.getUuidList()), (Object)"uuid", (Collection)entity.getUuidList());
        queryWrapper.eq(entity.getIsTenantAdmin() != null, (Object)"is_tenant_admin", (Object)entity.getIsTenantAdmin());
        queryWrapper.orderByAsc((Object)"update_time");
        List recordList = this.list((Wrapper)queryWrapper);
        return this.getUserSimple(recordList);
    }

    @Transactional
    public boolean frozen(UserDTO entity) {
        UserPO entity0 = this.getPoByUuid(entity.getUuid(), entity.getTenantNo());
        if (entity0 == null || CommonDeleteEnum.DELETED.getCode() == entity0.getIsDelete().intValue()) {
            throw new CuscUserException(ResponseCode.USER_INVALID.getCode(), ResponseCode.USER_INVALID.getMsg());
        }
        String userId = entity0.getUuid();
        UserPO bean = new UserPO();
        bean.setId(entity0.getId());
        bean.setStatus(Integer.valueOf(CommonStatusEnum.DISABLE.getCode()));
        boolean ret = this.updateById((Object)bean);
        this.urlService.delUserRelUrlRedis(userId, entity0.getTenantNo(), null);
        this.tokenService.kickOutByUserId(userId, entity.getTenantNo());
        return ret;
    }

    @Transactional
    public boolean unfreeze(UserDTO entity) {
        UserPO entity0 = this.getPoByUuid(entity.getUuid(), entity.getTenantNo());
        if (entity0 == null || CommonDeleteEnum.DELETED.getCode() == entity0.getIsDelete().intValue()) {
            throw new CuscUserException(ResponseCode.USER_INVALID.getCode(), ResponseCode.USER_INVALID.getMsg());
        }
        String userId = entity0.getUuid();
        UserPO bean = new UserPO();
        bean.setId(entity0.getId());
        bean.setStatus(Integer.valueOf(CommonStatusEnum.ENABLE.getCode()));
        boolean ret = this.updateById((Object)bean);
        this.urlService.userRelAppUrlToRedis(userId, entity0.getTenantNo());
        return ret;
    }

    public UserDTO getByUuid(UserDTO entity) {
        UserPO record = this.getPoByUuid(entity.getUuid(), entity.getTenantNo());
        return UserConverter.INSTANCE.poToDto(record);
    }

    public List<UserSimpleDTO> getByUuids(UserDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"uuid", (Collection)entity.getUuidList());
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"tenant_no", (Object)entity.getTenantNo());
        List recordList = this.list((Wrapper)queryWrapper);
        return this.getUserSimple(recordList);
    }

    private List<UserSimpleDTO> getUserSimple(List<UserPO> recordList) {
        ArrayList<UserSimpleDTO> retList = new ArrayList<UserSimpleDTO>();
        for (UserPO user : recordList) {
            UserSimpleDTO usDto = new UserSimpleDTO();
            BeanUtils.copyProperties((Object)user, (Object)usDto);
            retList.add(usDto);
        }
        return retList;
    }

    public List<UserDTO> queryUserByRoleId(UserRoleDTO entity) {
        return ((UserDao)this.baseMapper).queryUserByRoleId(entity);
    }

    @Transactional
    public boolean changeTenantAdmin(UserDTO bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getTenantNo()) || CuscStringUtils.isEmpty((String)bean.getUuid()) || CuscStringUtils.isEmpty((String)bean.getNewUserId())) {
            throw new CuscUserException(ResponseCode.PARAMETER_NULL.getCode(), ResponseCode.PARAMETER_NULL.getMsg());
        }
        UserDTO oldUser = this.getByUuid(bean);
        if (oldUser == null || CommonYesOrNoEnum.YES.getCode() != oldUser.getIsTenantAdmin().intValue()) {
            throw new CuscUserException(ResponseCode.USER_INVALID.getCode(), ResponseCode.USER_INVALID.getMsg());
        }
        UserDTO oldUserUpdate = new UserDTO();
        oldUserUpdate.setId(oldUser.getId());
        oldUserUpdate.setIsTenantAdmin(Integer.valueOf(CommonYesOrNoEnum.NO.getCode()));
        this.updateUser(oldUserUpdate);
        UserDTO newUser = new UserDTO();
        newUser.setUuid(bean.getNewUserId());
        newUser.setTenantNo(bean.getTenantNo());
        newUser = this.getByUuid(newUser);
        if (newUser == null) {
            throw new CuscUserException(ResponseCode.USER_INVALID.getCode(), ResponseCode.USER_INVALID.getMsg());
        }
        UserDTO newUserUpdate = new UserDTO();
        newUserUpdate.setId(oldUser.getId());
        newUserUpdate.setIsTenantAdmin(Integer.valueOf(CommonYesOrNoEnum.YES.getCode()));
        this.updateUser(newUserUpdate);
        return true;
    }

    public void allUserRelUrlToRedis(UserDTO bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getTenantNo()) || CuscStringUtils.isEmpty((String)bean.getApplicationId())) {
            throw new CuscUserException(ResponseCode.PARAMETER_NULL.getCode(), ResponseCode.PARAMETER_NULL.getMsg());
        }
        List userList = this.queryUserByParams(bean);
        if (CollectionUtils.isEmpty((Collection)userList)) {
            log.info("allUserRelUrlToRedis user list is empty!");
            return;
        }
        ArrayList<String> userIdList = new ArrayList<String>();
        for (UserPO user : userList) {
            userIdList.add(user.getUuid());
        }
        this.urlService.userListRelUrlToRedis(userIdList, bean.getTenantNo(), bean.getApplicationId());
    }

    @Transactional
    public boolean changePassword(UserDTO bean) {
        UserPO entity0 = this.getPoByUuid(bean.getUuid(), bean.getTenantNo());
        if (entity0 == null || CommonDeleteEnum.DELETED.getCode() == entity0.getIsDelete().intValue()) {
            throw new CuscUserException(ResponseCode.USER_INVALID.getCode(), ResponseCode.USER_INVALID.getMsg());
        }
        if (!Sm4Util.encryptEcbPadding((String)entity0.getUuid().substring(16), (String)bean.getPassword()).equals(entity0.getPassword())) {
            throw new CuscUserException(ResponseCode.USER_OLD_PASSWORD_ERROR.getCode(), ResponseCode.USER_OLD_PASSWORD_ERROR.getMsg());
        }
        PasswordChecker.checkPasswordRule((String)bean.getNewPassword(), (String)entity0.getUserName(), (String)entity0.getPhone(), (String)entity0.getEmail());
        UserPO userPO = new UserPO();
        userPO.setId(entity0.getId());
        userPO.setPassword(Sm4Util.encryptEcbPadding((String)entity0.getUuid().substring(16), (String)bean.getNewPassword()));
        return this.updateById((Object)userPO);
    }

    @Transactional
    public boolean resetPassword(UserPasswordDTO bean) {
        boolean ret;
        String newPassword;
        Response smsResp;
        UserPO entity0 = this.getPoByUuid(bean.getUuid(), bean.getTenantNo());
        if (entity0 == null || CommonDeleteEnum.DELETED.getCode() == entity0.getIsDelete().intValue()) {
            throw new CuscUserException(ResponseCode.USER_INVALID.getCode(), ResponseCode.USER_INVALID.getMsg());
        }
        if (CuscStringUtils.isEmpty((String)entity0.getPhone())) {
            throw new CuscUserException(ResponseCode.RESET_PASSWORDPHONE_NOT_NULL.getCode(), ResponseCode.RESET_PASSWORDPHONE_NOT_NULL.getMsg());
        }
        if (CuscStringUtils.isNotEmpty((String)bean.getSmsCode()) && !(smsResp = this.smsService.checkSmsCaptcha(entity0.getPhone(), bean.getTenantNo(), bean.getApplicationId(), bean.getSmsCode())).isSuccess().booleanValue()) {
            throw new CuscUserException(smsResp.getCode(), smsResp.getMsg());
        }
        if (CuscStringUtils.isEmpty((String)bean.getPassword())) {
            SmsSendConfig smsConfig = bean.getSmsSendConfig();
            ApplicationDTO appConfig = this.applicationService.getCacheByCode(bean.getApplicationId());
            this.smsService.convertToSmsConfig(appConfig, smsConfig);
            newPassword = this.createNewPassword();
            smsConfig.setIntervalLimitKey("CT:USER:SMS:INTERVAL:RESETPASSWORD:");
            smsConfig.setTotalLimitKey("CT:USER:SMS:DAY:RESETPASSWORD:");
            smsConfig.setTenantNo(bean.getTenantNo());
            smsConfig.setAppId(bean.getApplicationId());
            this.smsService.checkSmsSendLimit(entity0.getPhone(), smsConfig);
            UserPO userPO = new UserPO();
            userPO.setId(entity0.getId());
            userPO.setPassword(Sm4Util.encryptEcbPadding((String)entity0.getUuid().substring(16), (String)newPassword));
            ret = this.updateById((Object)userPO);
            this.smsService.sendSms(entity0.getPhone(), newPassword, smsConfig);
        } else {
            newPassword = bean.getPassword();
            PasswordChecker.checkPasswordRule((String)newPassword, (String)entity0.getUserName(), (String)entity0.getPhone(), (String)entity0.getEmail());
            UserPO userPO = new UserPO();
            userPO.setId(entity0.getId());
            userPO.setPassword(Sm4Util.encryptEcbPadding((String)entity0.getUuid().substring(16), (String)newPassword));
            ret = this.updateById((Object)userPO);
        }
        return ret;
    }

    public boolean getUserOnline(UserDTO bean) {
        try {
            String userTokenListKey = "CT:USER:AUTH:TOKEN:USER:" + bean.getTenantNo() + ":" + bean.getUuid();
            List userList = this.cacheFactory.getExpireListService().getList(userTokenListKey, UserTokenListDTO.class);
            if (CollectionUtils.isEmpty((Collection)userList)) {
                return false;
            }
            for (UserTokenListDTO userToken : userList) {
                if (!userToken.getAppId().equals(bean.getApplicationId())) continue;
                return true;
            }
        }
        catch (CacheException e) {
            log.error("getUserOnline \u8bbf\u95eereids\u5931\u8d25 :{}", (Throwable)e);
            return false;
        }
        return false;
    }

    public List<UserDTO> queryAdminUserListByUserIdList(List<String> userIdList, boolean tenantAdmin) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.emptyList();
        }
        List list = tenantAdmin ? ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UserPO::getUuid, userIdList)).eq(UserPO::getIsTenantAdmin, (Object)1)).list() : ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UserPO::getUuid, userIdList)).ne(UserPO::getOrdinaryAdmin, (Object)0)).list();
        return UserConverter.INSTANCE.poListToDtoList(list);
    }

    public List<UserDTO> queryAdminUserListByUserIdListNew(List<String> userIdList, boolean tenantAdmin) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.emptyList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UserPO::getUuid, userIdList)).ne(UserPO::getOrdinaryAdmin, (Object)0)).list();
        return UserConverter.INSTANCE.poListToDtoList(list);
    }

    private List<UserPO> queryUserByParams(UserDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.eq((Object)"tenant_no", (Object)entity.getTenantNo());
        queryWrapper.in(!CollectionUtils.isEmpty((Collection)entity.getTenantNoList()), (Object)"tenant_no", (Collection)entity.getTenantNoList());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getUserName()), (Object)"user_name", (Object)entity.getUserName());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getPhone()), (Object)"phone", (Object)entity.getPhone());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getEmail()), (Object)"email", (Object)entity.getEmail());
        queryWrapper.ne(entity.getId() != null, (Object)"id", (Object)entity.getId());
        return this.list((Wrapper)queryWrapper);
    }

    private UserPO getPoByUuid(String uuid, String tenantNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)tenantNo), (Object)"tenant_no", (Object)tenantNo);
        return (UserPO)this.getOne((Wrapper)queryWrapper);
    }

    private String createNewPassword() {
        char[] chars = new char[9];
        Random rnd = new Random();
        int specialPosition = rnd.nextInt(7) + 1;
        for (int i = 0; i < 9; ++i) {
            chars[i] = specialPosition == i ? 64 : UserServiceImpl.nextChar((Random)rnd);
        }
        return new String(chars);
    }

    private static char nextChar(Random rnd) {
        switch (rnd.nextInt(3)) {
            case 0: {
                return (char)(97 + rnd.nextInt(26));
            }
            case 1: {
                return (char)(65 + rnd.nextInt(26));
            }
        }
        return (char)(48 + rnd.nextInt(10));
    }
}

