/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.converter.UserOrganConverter;
import com.cusc.nirvana.user.eiam.dao.UserOrganDao;
import com.cusc.nirvana.user.eiam.dao.entity.UserOrganPO;
import com.cusc.nirvana.user.eiam.dto.UserOrganDTO;
import com.cusc.nirvana.user.eiam.service.IUserOrganService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UserOrganServiceImpl
extends ServiceImpl<UserOrganDao, UserOrganPO>
implements IUserOrganService {
    public UserOrganDTO getByUuid(UserOrganDTO userOrgan) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)userOrgan.getUuid());
        queryWrapper.eq((Object)"is_delete", (Object)0);
        UserOrganPO record = (UserOrganPO)this.getOne((Wrapper)queryWrapper);
        return UserOrganConverter.INSTANCE.poToDto(record);
    }

    public List<UserOrganDTO> queryByList(UserOrganDTO userOrgan) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)userOrgan.getTenantNo()), (Object)"tenant_no", (Object)userOrgan.getTenantNo());
        if (!CollectionUtils.isEmpty((Collection)userOrgan.getOrganIdList())) {
            queryWrapper.in((Object)"organ_id", (Collection)userOrgan.getOrganIdList());
        }
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)userOrgan.getUserId()), (Object)"user_id", (Object)userOrgan.getUserId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)userOrgan.getOrganId()), (Object)"organ_id", (Object)userOrgan.getOrganId());
        List record = this.list((Wrapper)queryWrapper);
        return UserOrganConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<UserOrganDTO> queryByPage(UserOrganDTO userOrgan) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)0);
        Page page = (Page)this.page((IPage)new Page((long)userOrgan.getCurrPage().intValue(), (long)userOrgan.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, UserOrganDTO.class);
    }

    @Transactional
    public UserOrganDTO insert(UserOrganDTO userOrgan) {
        UserOrganPO userOrganPO = UserOrganConverter.INSTANCE.dtoToPo(userOrgan);
        this.save((Object)userOrganPO);
        return userOrgan;
    }

    @Transactional
    public UserOrganDTO update(UserOrganDTO userOrgan) {
        UserOrganPO userOrganPO = this.getPoByUuid(userOrgan.getUuid());
        this.updateById((Object)userOrganPO);
        return userOrgan;
    }

    @Transactional
    public boolean deleteById(UserOrganDTO userOrgan) {
        UserOrganPO userOrganPO = this.getPoByUuid(userOrgan.getUuid());
        return this.updateById((Object)userOrganPO);
    }

    private UserOrganPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)0);
        return (UserOrganPO)this.getOne((Wrapper)queryWrapper);
    }
}

