/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.eiam.common.BaseIamDTO;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.constants.CommonStatusEnum;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.converter.OrganizationConverter;
import com.cusc.nirvana.user.eiam.dao.OrganizationDao;
import com.cusc.nirvana.user.eiam.dao.entity.OrganizationPO;
import com.cusc.nirvana.user.eiam.dto.OrganizationDTO;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.eiam.dto.UserOrganDTO;
import com.cusc.nirvana.user.eiam.service.IOrganizationService;
import com.cusc.nirvana.user.eiam.service.IUserOrganService;
import com.cusc.nirvana.user.eiam.service.IUserService;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrganizationServiceImpl
extends ServiceImpl<OrganizationDao, OrganizationPO>
implements IOrganizationService {
    @Resource
    private IUserOrganService userOrganService;
    @Resource
    private IUserService userService;

    public OrganizationDTO getByUuid(OrganizationDTO organization) {
        OrganizationPO organizationPO = this.getPoByUuid(organization.getUuid(), organization.getTenantNo());
        return OrganizationConverter.INSTANCE.poToDto(organizationPO);
    }

    public List<OrganizationDTO> queryByList(OrganizationDTO organization) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)organization.getTenantNo()), (Object)"tenant_no", (Object)organization.getTenantNo());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)organization.getOrganCode()), (Object)"organ_code", (Object)organization.getOrganCode());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)organization.getOrganName()), (Object)"organ_name", (Object)organization.getOrganName());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)organization.getParentId()), (Object)"parent_id", (Object)organization.getParentId());
        queryWrapper.eq(organization.getOrganType() != null, (Object)"organ_type", (Object)organization.getOrganType());
        queryWrapper.eq(organization.getStatus() != null, (Object)"status", (Object)organization.getStatus());
        queryWrapper.eq(organization.getBizType() != null, (Object)"biz_type", (Object)organization.getBizType());
        queryWrapper.in(!CollectionUtils.isEmpty((Collection)organization.getBizTypeList()), (Object)"biz_type", (Collection)organization.getBizTypeList());
        queryWrapper.likeRight(CuscStringUtils.isNotEmpty((String)organization.getQueryCode()), (Object)"query_code", (Object)organization.getQueryCode());
        if (!CollectionUtils.isEmpty((Collection)organization.getUuidList())) {
            queryWrapper.in((Object)"uuid", (Collection)organization.getUuidList());
        }
        List record = this.list((Wrapper)queryWrapper);
        return OrganizationConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<OrganizationDTO> queryByPage(OrganizationDTO organization) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        if (StringUtils.isNotBlank((CharSequence)organization.getTenantNo())) {
            queryWrapper.eq((Object)"tenant_no", (Object)organization.getTenantNo());
        }
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)organization.getOrganCode()), (Object)"organ_code", (Object)organization.getOrganCode());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)organization.getOrganName()), (Object)"organ_name", (Object)organization.getOrganName());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)organization.getOrganSimpleName()), (Object)"organ_simple_name", (Object)organization.getOrganSimpleName());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)organization.getParentId()), (Object)"parent_id", (Object)organization.getParentId());
        queryWrapper.eq(organization.getOrganType() != null, (Object)"organ_type", (Object)organization.getOrganType());
        queryWrapper.eq(organization.getStatus() != null, (Object)"status", (Object)organization.getStatus());
        queryWrapper.eq(organization.getBizType() != null, (Object)"biz_type", (Object)organization.getBizType());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)organization.getUniqueCode()), (Object)"unique_code", (Object)organization.getUniqueCode());
        queryWrapper.likeRight(CuscStringUtils.isNotEmpty((String)organization.getQueryCode()), (Object)"query_code", (Object)organization.getQueryCode());
        Page page = (Page)this.page((IPage)new Page((long)organization.getCurrPage().intValue(), (long)organization.getPageSize().intValue()), (Wrapper)queryWrapper);
        PageResult result = PageHelper.convert((Page)page, OrganizationDTO.class);
        List poList = page.getRecords();
        Map adminMap = this.queryOrganAdmin(poList, null == organization.getParentId() || "0".equals(organization.getParentId()), organization.getType());
        List dtoList = result.getList();
        dtoList.forEach(dto -> {
            UserDTO userDTO = (UserDTO)adminMap.get(dto.getUuid());
            if (null != userDTO) {
                dto.setAdminUserId(userDTO.getUuid());
                dto.setAdminAccount(userDTO.getUserName());
                dto.setAdminName(userDTO.getFullName());
                dto.setAdminPhone(userDTO.getPhone());
                dto.setCreateTime(userDTO.getCreateTime());
            }
        });
        return result;
    }

    private Map<String, UserDTO> queryOrganAdmin(List<OrganizationPO> poList, boolean tenantAdmin, String type) {
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyMap();
        }
        Map organMap = poList.stream().collect(Collectors.toMap(OrganizationPO::getUuid, Function.identity(), (k, v) -> v));
        List orgUuidList = poList.stream().map(OrganizationPO::getUuid).distinct().collect(Collectors.toList());
        UserOrganDTO userOrgDto = new UserOrganDTO();
        userOrgDto.setOrganIdList(orgUuidList);
        List userOrganDTOS = this.userOrganService.queryByList(userOrgDto);
        Map<String, String> userOrganMap = userOrganDTOS.stream().collect(Collectors.toMap(UserOrganDTO::getUserId, UserOrganDTO::getOrganId, (k, v) -> v));
        List userIdList = userOrganDTOS.stream().map(UserOrganDTO::getUserId).distinct().collect(Collectors.toList());
        List userDTOS = StringUtils.isNotEmpty((CharSequence)type) && "1".equals(type) ? this.userService.queryAdminUserListByUserIdListNew(userIdList, tenantAdmin) : this.userService.queryAdminUserListByUserIdList(userIdList, tenantAdmin);
        Map userMap = userDTOS.stream().collect(Collectors.toMap(BaseIamDTO::getUuid, Function.identity(), (k, v) -> v));
        HashMap<String, UserDTO> resultMap = new HashMap<String, UserDTO>(poList.size());
        userMap.forEach((userId, userDto) -> {
            String organId = (String)userOrganMap.get(userId);
            if (StringUtils.isNotBlank((CharSequence)organId)) {
                resultMap.put(organId, (UserDTO)userDto);
            }
        });
        return resultMap;
    }

    @Transactional
    public OrganizationDTO insert(OrganizationDTO organization) {
        OrganizationPO organizationPO = OrganizationConverter.INSTANCE.dtoToPo(organization);
        String orgId = CuscStringUtils.generateUuid();
        organizationPO.setUuid(orgId);
        if ("0".equals(organization.getParentId())) {
            organizationPO.setQueryCode("0-" + orgId);
        } else {
            OrganizationPO parentPO = this.getPoByUuid(organization.getParentId(), organization.getTenantNo());
            if (parentPO == null) {
                throw new CuscUserException(ResponseCode.ORGAN_PARENT_INVALID.getCode(), ResponseCode.ORGAN_PARENT_INVALID.getMsg());
            }
            organizationPO.setQueryCode(parentPO.getQueryCode() + "-" + orgId);
        }
        this.save((Object)organizationPO);
        organization.setUuid(organizationPO.getUuid());
        return organization;
    }

    @Transactional
    public OrganizationDTO update(OrganizationDTO organization) {
        OrganizationPO organizationPO = this.getPoByUuid(organization.getUuid(), organization.getTenantNo());
        if (null == organizationPO) {
            return organization;
        }
        OrganizationPO updatePo = OrganizationConverter.INSTANCE.dtoToPo(organization);
        updatePo.setId(organizationPO.getId());
        updatePo.setUuid(null);
        updatePo.setOrganCode(null);
        updatePo.setTenantNo(null);
        if (CuscStringUtils.isNotEmpty((String)organization.getParentId()) && !organization.getParentId().equals(organizationPO.getParentId())) {
            OrganizationPO parentPO = this.getPoByUuid(organization.getParentId(), organization.getTenantNo());
            if (parentPO == null) {
                throw new CuscUserException(ResponseCode.ORGAN_PARENT_INVALID.getCode(), ResponseCode.ORGAN_PARENT_INVALID.getMsg());
            }
            String newQueryCode = parentPO.getQueryCode() + "-" + organizationPO.getUuid();
            this.updateChildQueryCode(organizationPO.getQueryCode(), newQueryCode, organizationPO.getTenantNo());
            organizationPO.setQueryCode(newQueryCode);
        }
        this.updateById((Object)updatePo);
        return organization;
    }

    @Transactional
    public boolean deleteById(OrganizationDTO organization) {
        OrganizationPO organizationPO = this.getPoByUuid(organization.getUuid(), organization.getTenantNo());
        return this.updateById((Object)organizationPO);
    }

    @Transactional
    public boolean frozen(OrganizationDTO bean) {
        OrganizationPO organPO = this.getPoByUuid(bean.getUuid(), bean.getTenantNo());
        if (organPO == null) {
            return false;
        }
        OrganizationPO tmpBean = new OrganizationPO();
        tmpBean.setId(organPO.getId());
        tmpBean.setStatus(Integer.valueOf(CommonStatusEnum.DISABLE.getCode()));
        return this.updateById((Object)tmpBean);
    }

    @Transactional
    public boolean unfreeze(OrganizationDTO bean) {
        OrganizationPO organPO = this.getPoByUuid(bean.getUuid(), bean.getTenantNo());
        if (organPO == null) {
            return false;
        }
        OrganizationPO tmpBean = new OrganizationPO();
        tmpBean.setId(organPO.getId());
        tmpBean.setStatus(Integer.valueOf(CommonStatusEnum.ENABLE.getCode()));
        return this.updateById((Object)tmpBean);
    }

    public List<OrganizationDTO> getOrganListByUserId(UserOrganDTO bean) {
        return OrganizationConverter.INSTANCE.poListToDtoList(((OrganizationDao)this.baseMapper).queryOrganListByUserId(bean));
    }

    private OrganizationPO getPoByUuid(String uuid, String tenantNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)tenantNo), (Object)"tenant_no", (Object)tenantNo);
        return (OrganizationPO)this.getOne((Wrapper)queryWrapper);
    }

    private void updateChildQueryCode(String oldQueryCode, String newQueryCode, String tenantNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.likeRight((Object)"query_code", (Object)oldQueryCode);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"tenant_no", (Object)tenantNo);
        List orgList = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)orgList)) {
            for (OrganizationPO tempOrg : orgList) {
                OrganizationPO updatePO = new OrganizationPO();
                updatePO.setId(tempOrg.getId());
                updatePO.setQueryCode(tempOrg.getQueryCode().replaceAll(oldQueryCode, newQueryCode));
                this.updateById((Object)updatePO);
            }
        }
    }
}

