/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.UserTokenListDTO;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EiamTokenService {
    private static final Logger log = LoggerFactory.getLogger(EiamTokenService.class);
    @Autowired
    private CacheFactory cacheFactory;

    public Response kickOutByUserId(String userId, String tenantNo) {
        try {
            String userTokenListKey = "CT:USER:AUTH:TOKEN:USER:" + tenantNo + ":" + userId;
            List userList = this.cacheFactory.getExpireListService().getList(userTokenListKey, UserTokenListDTO.class);
            if (CollectionUtils.isEmpty((Collection)userList)) {
                return Response.createSuccess();
            }
            for (UserTokenListDTO userToken : userList) {
                this.cacheFactory.getExpireHashService().delete(new String[]{"CT:USER:AUTH:TOKEN:REFRESH_TOKEN:" + userToken.getRefresh()});
                this.cacheFactory.getExpireHashService().delete(new String[]{"CT:USER:AUTH:TOKEN:ACCESS_TOKEN:" + userToken.getAccess()});
            }
            this.cacheFactory.getExpireListService().delete(new String[]{userTokenListKey});
        }
        catch (CacheException e) {
            log.error("kickOutByUserId \u8bbf\u95eereids\u5931\u8d25 :{}", (Throwable)e);
            return Response.createError((String)ResponseCode.KICK_OUT_FAIL.getMsg(), (String)(ResponseCode.KICK_OUT_FAIL.getCode() + ""));
        }
        return Response.createSuccess();
    }
}

