/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.eiam.converter.DataOperationLogConverter;
import com.cusc.nirvana.user.eiam.dao.DataOperationLogDao;
import com.cusc.nirvana.user.eiam.dao.entity.DataOperationLogPO;
import com.cusc.nirvana.user.eiam.dto.DataOperationLogDTO;
import com.cusc.nirvana.user.eiam.service.IDataOperationLogService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataOperationLogServiceImpl
extends ServiceImpl<DataOperationLogDao, DataOperationLogPO>
implements IDataOperationLogService {
    public DataOperationLogDTO getByUuid(DataOperationLogDTO dataOperationLog) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)dataOperationLog.getUuid());
        queryWrapper.eq((Object)"is_delete", (Object)0);
        DataOperationLogPO record = (DataOperationLogPO)this.getOne((Wrapper)queryWrapper);
        return DataOperationLogConverter.INSTANCE.poToDto(record);
    }

    public List<DataOperationLogDTO> queryByList(DataOperationLogDTO dataOperationLog) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return DataOperationLogConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<DataOperationLogDTO> queryByPage(DataOperationLogDTO dataOperationLog) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)0);
        Page page = (Page)this.page((IPage)new Page((long)dataOperationLog.getCurrPage().intValue(), (long)dataOperationLog.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, DataOperationLogDTO.class);
    }

    @Transactional
    public DataOperationLogDTO insert(DataOperationLogDTO dataOperationLog) {
        DataOperationLogPO dataOperationLogPO = DataOperationLogConverter.INSTANCE.dtoToPo(dataOperationLog);
        this.save((Object)dataOperationLogPO);
        return dataOperationLog;
    }

    @Transactional
    public DataOperationLogDTO update(DataOperationLogDTO dataOperationLog) {
        DataOperationLogPO dataOperationLogPO = this.getPoByUuid(dataOperationLog.getUuid());
        this.updateById((Object)dataOperationLogPO);
        return dataOperationLog;
    }

    @Transactional
    public boolean deleteById(DataOperationLogDTO dataOperationLog) {
        DataOperationLogPO dataOperationLogPO = this.getPoByUuid(dataOperationLog.getUuid());
        return this.updateById((Object)dataOperationLogPO);
    }

    private DataOperationLogPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)0);
        return (DataOperationLogPO)this.getOne((Wrapper)queryWrapper);
    }
}

