/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.identification.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.common.encrypt.sign.HMAC;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.common.dto.SmsResponseDTO;
import com.cusc.nirvana.user.auth.common.dto.SmsSendDTO;
import com.cusc.nirvana.user.auth.identification.dto.SmsSendConfig;
import com.cusc.nirvana.user.auth.identification.service.ISmsService;
import com.cusc.nirvana.user.config.SmsPropertyConfig;
import com.cusc.nirvana.user.eiam.dto.ApplicationDTO;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.DateUtils;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SmsServiceImpl
implements ISmsService {
    private static final Logger log = LoggerFactory.getLogger(SmsServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(SmsServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private SmsPropertyConfig smsPropertyConfig;
    @Autowired
    private CacheFactory cacheFactory;
    @Value(value="${sms.cusc.strategyCode:}")
    private String strategyCode;
    @Value(value="${sms.cusc.templateCode:}")
    private String smsTemplate;

    public SmsResponseDTO sendSms(String phone, List<String> paramterList, SmsSendConfig config) {
        Response retResp;
        SmsSendDTO send = new SmsSendDTO();
        if (CuscStringUtils.isEmpty((String)this.smsPropertyConfig.getAccessKey())) {
            send.setAccesskey(config.getSmsPlatformKey());
        } else {
            send.setAccesskey(this.smsPropertyConfig.getAccessKey());
        }
        ArrayList<String> phoneList = new ArrayList<String>();
        phoneList.add(phone);
        send.setPhoneNumbers(phoneList);
        send.setTemplateParams(paramterList);
        if (CuscStringUtils.isEmpty((String)this.smsPropertyConfig.getSignatureCode())) {
            send.setSignatureCode(config.getSmsSignatureCode());
        } else {
            send.setSignatureCode(this.smsPropertyConfig.getSignatureCode());
        }
        send.setStrategyCode(this.strategyCode);
        send.setTemplateCode(this.smsTemplate);
        try {
            HttpEntity httpEntity = new HttpEntity((Object)JSON.toJSONString((Object)send), (MultiValueMap)this.headers());
            String url = this.smsPropertyConfig.getSmsUrl() + this.smsPropertyConfig.getSendUrl();
            log.info("SmsServiceImpl sendSms \u77ed\u4fe1\u5e73\u53f0  url : {}, request : {}", (Object)url, (Object)JSON.toJSONString((Object)httpEntity));
            ResponseEntity entity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            retResp = (Response)JSON.parseObject((String)((String)entity.getBody()), (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
            log.info("SmsServiceImpl sendSms \u77ed\u4fe1\u5e73\u53f0  url : {}, response : {}", (Object)url, (Object)JSON.toJSONString((Object)retResp));
        }
        catch (Exception e) {
            LOGGER.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff1a ", (Throwable)e);
            throw new CuscUserException(ResponseCode.SMS_CAPTCHA_SEND_FAIL.getCode() + "", ResponseCode.SMS_CAPTCHA_SEND_FAIL.getMsg());
        }
        this.saveSmsSendLimitToRedis(phone, config);
        if (retResp != null) {
            return (SmsResponseDTO)retResp.getData();
        }
        return null;
    }

    public SmsResponseDTO sendSms(String phone, String parameter, SmsSendConfig config) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(parameter);
        return this.sendSms(phone, list, config);
    }

    public boolean checkSmsConfigNotNull(SmsSendConfig bean) {
        return bean != null;
    }

    public void convertToSmsConfig(ApplicationDTO fromBean, SmsSendConfig toBean) {
        if (!this.checkSmsConfigNotNull(toBean)) {
            throw new CuscUserException(ResponseCode.SMS_SEND_CONFIG_NOT_NULL.getCode() + "", ResponseCode.SMS_SEND_CONFIG_NOT_NULL.getMsg());
        }
        if (toBean.getSmsTotalLimit() == null) {
            if (fromBean.getSmsTotalLimit() == null) {
                log.warn("sms config smsTotalLimit is null");
                throw new CuscUserException(ResponseCode.SMS_SEND_CONFIG_NOT_NULL.getCode() + "", ResponseCode.SMS_SEND_CONFIG_NOT_NULL.getMsg());
            }
            toBean.setSmsTotalLimit(fromBean.getSmsTotalLimit());
        }
        if (toBean.getSmsIntervalLimit() == null) {
            if (fromBean.getSmsIntervalLimit() == null) {
                log.warn("sms config smsIntervalLimit is null");
                throw new CuscUserException(ResponseCode.SMS_SEND_CONFIG_NOT_NULL.getCode() + "", ResponseCode.SMS_SEND_CONFIG_NOT_NULL.getMsg());
            }
            toBean.setSmsIntervalLimit(fromBean.getSmsIntervalLimit());
        }
        if (toBean.getSmsPlatformKey() == null) {
            if (fromBean.getSmsPlatformKey() == null) {
                log.warn("sms config smsPlatformKey is null");
                throw new CuscUserException(ResponseCode.SMS_SEND_CONFIG_NOT_NULL.getCode() + "", ResponseCode.SMS_SEND_CONFIG_NOT_NULL.getMsg());
            }
            toBean.setSmsPlatformKey(fromBean.getSmsPlatformKey());
        }
        if (toBean.getSmsSignatureCode() == null) {
            if (fromBean.getSmsSignatureCode() == null) {
                log.warn("sms config smsSignatureCode is null");
                throw new CuscUserException(ResponseCode.SMS_SEND_CONFIG_NOT_NULL.getCode() + "", ResponseCode.SMS_SEND_CONFIG_NOT_NULL.getMsg());
            }
            toBean.setSmsSignatureCode(fromBean.getSmsSignatureCode());
        }
    }

    public void checkSmsSendLimit(String phone, SmsSendConfig bean) {
        try {
            boolean isExists;
            Integer smsTotal;
            if (bean.getSmsTotalLimit() != null && bean.getSmsTotalLimit() > 0 && CuscStringUtils.isNotEmpty((String)bean.getTotalLimitKey()) && (smsTotal = (Integer)this.cacheFactory.getExpireStringService().getValue(bean.getTotalLimitKey() + phone + "_" + bean.getTenantNo() + "_" + bean.getAppId(), Integer.class)) != null && smsTotal >= bean.getSmsTotalLimit()) {
                throw new CuscUserException(ResponseCode.SMS_TOTAL_LIMIT_OVERRUN.getCode(), ResponseCode.SMS_TOTAL_LIMIT_OVERRUN.getMsg());
            }
            if (bean.getSmsIntervalLimit() != null && bean.getSmsIntervalLimit() > 0 && CuscStringUtils.isNotEmpty((String)bean.getIntervalLimitKey()) && (isExists = this.cacheFactory.getExpireStringService().containsKey(bean.getIntervalLimitKey() + phone + "_" + bean.getTenantNo() + "_" + bean.getAppId()).booleanValue())) {
                throw new CuscUserException(ResponseCode.SMS_INTERVAL_LIMIT_OVERRUN.getCode(), ResponseCode.SMS_INTERVAL_LIMIT_OVERRUN.getMsg());
            }
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u77ed\u4fe1\u53d1\u9001\u9650\u5236\u4fe1\u606f\u65f6\u8bbf\u95eeredis \u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private void saveSmsSendLimitToRedis(String phone, SmsSendConfig bean) {
        try {
            if (bean.getSmsTotalLimit() != null && bean.getSmsTotalLimit() > 0 && CuscStringUtils.isNotEmpty((String)bean.getTotalLimitKey())) {
                Long expireTime;
                Integer smsTotal = (Integer)this.cacheFactory.getExpireStringService().getValue(bean.getTotalLimitKey() + phone + "_" + bean.getTenantNo() + "_" + bean.getAppId(), Integer.class);
                if (smsTotal == null) {
                    smsTotal = 1;
                    LocalDateTime begin = LocalDateTime.now();
                    expireTime = DateUtils.secondBetween((LocalDateTime)begin, (LocalDateTime)DateUtils.getDayEnd((LocalDateTime)begin));
                } else {
                    Integer n = smsTotal;
                    Integer n2 = smsTotal = Integer.valueOf(smsTotal + 1);
                    expireTime = this.cacheFactory.getExpireStringService().getKeyExpireTime(bean.getTotalLimitKey() + phone + "_" + bean.getTenantNo() + "_" + bean.getAppId());
                }
                this.cacheFactory.getExpireStringService().setExpireValue(bean.getTotalLimitKey() + phone + "_" + bean.getTenantNo() + "_" + bean.getAppId(), (Object)smsTotal, expireTime.intValue());
            }
            if (bean.getSmsIntervalLimit() != null && bean.getSmsIntervalLimit() > 0 && CuscStringUtils.isNotEmpty((String)bean.getIntervalLimitKey())) {
                this.cacheFactory.getExpireStringService().setExpireValue(bean.getIntervalLimitKey() + phone + "_" + bean.getTenantNo() + "_" + bean.getAppId(), (Object)1, bean.getSmsIntervalLimit().intValue());
            }
        }
        catch (CacheException e) {
            log.error("\u4fdd\u5b58\u77ed\u4fe1\u53d1\u9001\u9650\u5236\u4fe1\u606f\u5230redis \u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public HttpHeaders headers() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("APPID", this.smsPropertyConfig.getAPPID());
        httpHeaders.add("NONCE_STR", CuscStringUtils.generateUuid());
        httpHeaders.add("TIMESTAMP", String.valueOf(System.currentTimeMillis()));
        httpHeaders.add("VERSION", this.smsPropertyConfig.getVERSION());
        httpHeaders.setContentType(MediaType.parseMediaType((String)"application/json; charset=UTF-8"));
        StringBuilder sb = new StringBuilder();
        sb.append("APPID" + this.smsPropertyConfig.getAPPID());
        sb.append("NONCE_STR" + (String)httpHeaders.get((Object)"NONCE_STR").get(0));
        sb.append("TIMESTAMP" + (String)httpHeaders.get((Object)"TIMESTAMP").get(0));
        sb.append("VERSION" + (String)httpHeaders.get((Object)"VERSION").get(0));
        String scret = HMAC.sign((String)sb.toString(), (String)this.smsPropertyConfig.getAPPSCRET(), (HMAC.Type)HMAC.Type.HmacSHA256);
        httpHeaders.add("SIGN", scret);
        return httpHeaders;
    }
}

