/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.identification.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.common.constants.UserTypeEnum;
import com.cusc.nirvana.user.auth.common.service.AppConfigService;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaVerificationReq;
import com.cusc.nirvana.user.auth.identification.dto.MobileLoginReq;
import com.cusc.nirvana.user.auth.identification.dto.Oauth2Token;
import com.cusc.nirvana.user.auth.identification.dto.SmsSendConfig;
import com.cusc.nirvana.user.auth.identification.dto.UserNameLoginReq;
import com.cusc.nirvana.user.auth.identification.service.ICaptchaService;
import com.cusc.nirvana.user.auth.identification.service.ILoginService;
import com.cusc.nirvana.user.auth.identification.service.IRandomIdService;
import com.cusc.nirvana.user.auth.identification.service.ISmsService;
import com.cusc.nirvana.user.auth.identification.service.ITokenService;
import com.cusc.nirvana.user.ciam.dto.CiamUserDTO;
import com.cusc.nirvana.user.ciam.service.ICiamUserService;
import com.cusc.nirvana.user.eiam.constants.CommonStatusEnum;
import com.cusc.nirvana.user.eiam.dto.ApplicationDTO;
import com.cusc.nirvana.user.eiam.dto.EiamUrlDTO;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.eiam.service.IUrlService;
import com.cusc.nirvana.user.eiam.service.IUserService;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscRandomUtils;
import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.crypt.Sm4Util;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements ILoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);
    @Autowired
    private CacheFactory cacheFactory;
    @Autowired
    private IUserService userClient;
    @Autowired
    private IUrlService eiamUrlClient;
    @Autowired
    private ITokenService tokenService;
    @Autowired
    private ISmsService smsService;
    @Autowired
    private ICaptchaService captchaService;
    @Autowired
    private AppConfigService appConfigService;
    @Autowired
    private IRandomIdService randomIdService;
    @Autowired
    private ICiamUserService ciamUserClient;

    public Response<Oauth2Token> mobileLogin(MobileLoginReq bean) {
        Response ret = this.checkSmsCaptcha(bean);
        if (!ret.isSuccess().booleanValue()) {
            return ret;
        }
        Response retUser = this.checkUserByPhone(bean);
        if (!retUser.isSuccess().booleanValue()) {
            return Response.createError((String)retUser.getMsg(), (Integer)retUser.getCode());
        }
        this.eiamUrlClient.userRoleResUrlToRedis(((UserDTO)retUser.getData()).getUuid(), bean.getTenantNo(), bean.getApplicationId());
        return this.tokenService.createOauth2TokenByMobile(bean, (UserDTO)retUser.getData());
    }

    public Response<Oauth2Token> ciamMobileLogin(MobileLoginReq bean) {
        Response ret = this.checkSmsCaptcha(bean);
        if (!ret.isSuccess().booleanValue()) {
            return ret;
        }
        Response userResp = this.checkCiamUserByPhone(bean);
        CiamUserDTO ciamUser = (CiamUserDTO)userResp.getData();
        UserDTO userDTO = new UserDTO();
        userDTO.setApplicationId(bean.getApplicationId());
        userDTO.setTenantNo(bean.getTenantNo());
        userDTO.setPhone(ciamUser.getPhoneNum());
        userDTO.setUuid(ciamUser.getUuid());
        return this.tokenService.createOauth2TokenByMobile(bean, userDTO);
    }

    public Response<Oauth2Token> ciamMobileLoginXP(MobileLoginReq bean) {
        UserDTO userDTO = new UserDTO();
        CiamUserDTO ciamUser = new CiamUserDTO();
        ciamUser.setPhoneNum(bean.getPhone());
        ciamUser.setTenantNo(bean.getTenantNo());
        CiamUserDTO selectCiamUserDTO = this.ciamUserClient.getUserByPhoneTenantNo(ciamUser);
        System.out.println(JSONObject.toJSONString((Object)selectCiamUserDTO));
        if (null != selectCiamUserDTO) {
            userDTO.setPhone(selectCiamUserDTO.getPhoneNum());
            userDTO.setUuid(selectCiamUserDTO.getUuid());
        } else {
            CiamUserDTO insertBean = new CiamUserDTO();
            insertBean.setPhoneNum(bean.getPhone());
            insertBean.setTenantNo(bean.getTenantNo());
            CiamUserDTO insertReturnBean = this.ciamUserClient.addOrGet(insertBean);
            userDTO.setPhone(insertReturnBean.getPhoneNum());
            userDTO.setUuid(insertReturnBean.getUuid());
        }
        userDTO.setApplicationId(bean.getApplicationId());
        userDTO.setTenantNo(bean.getTenantNo());
        return this.tokenService.createOauth2TokenByMobile(bean, userDTO);
    }

    public Response<Oauth2Token> userLoginAdd(MobileLoginReq bean) {
        UserDTO userDTO;
        Response ret = this.checkSmsCaptcha(bean);
        if (!ret.isSuccess().booleanValue()) {
            return ret;
        }
        Response userResp = this.checkCiamUserByPhone(bean);
        String uuid = CuscStringUtils.generateUuid();
        if (!userResp.isSuccess().booleanValue()) {
            if (ResponseCode.LOGIN_NAME_STOP.getCode().equals(userResp.getCode())) {
                return Response.createError((String)userResp.getMsg(), (Integer)userResp.getCode());
            }
            userDTO = new CiamUserDTO();
            userDTO.setPhoneNum(bean.getPhone());
            userDTO.setUuid(uuid);
            userDTO.setTenantNo(bean.getTenantNo());
            this.ciamUserClient.addOrGet((CiamUserDTO)userDTO);
        }
        userDTO = new UserDTO();
        userDTO.setApplicationId(bean.getApplicationId());
        userDTO.setTenantNo(bean.getTenantNo());
        userDTO.setPhone(bean.getPhone());
        userDTO.setUuid(userResp.isSuccess() != false ? ((CiamUserDTO)userResp.getData()).getUuid() : uuid);
        return this.tokenService.createOauth2TokenByMobile(bean, userDTO);
    }

    public Response<Boolean> checkSmsCaptcha(MobileLoginReq bean) {
        String smsCaptcha = null;
        try {
            smsCaptcha = (String)this.cacheFactory.getExpireStringService().getValue("CT:USER:AUTH:SMS:CAPTCHA:" + bean.getPhone() + "_" + bean.getTenantNo() + "_" + bean.getApplicationId(), String.class);
            if (CuscStringUtils.isEmpty((String)smsCaptcha) || !smsCaptcha.equals(bean.getCaptcha())) {
                return Response.createError((String)ResponseCode.SMS_CAPTCHA_INVALID.getMsg(), (String)(ResponseCode.SMS_CAPTCHA_INVALID.getCode() + ""));
            }
            this.cacheFactory.getExpireStringService().delete(new String[]{"CT:USER:AUTH:SMS:CAPTCHA:" + bean.getPhone() + "_" + bean.getTenantNo() + "_" + bean.getApplicationId()});
        }
        catch (CacheException e) {
            log.error("checkSmsCaptcha \u83b7\u53d6reids\u5931\u8d25 \uff1a", (Throwable)e);
            Response.createError((String)ResponseCode.SMS_GET_CAPTCHA_FAIL.getMsg(), (String)(ResponseCode.SMS_GET_CAPTCHA_FAIL.getCode() + ""));
        }
        return Response.createSuccess((Object)true);
    }

    public Response<Oauth2Token> userNameLogin(UserNameLoginReq bean) {
        Response retUser;
        ApplicationDTO appBean = this.appConfigService.getAppConfigByCode(bean.getApplicationId());
        this.checkUserNameLock(bean);
        String respPwd = bean.getPassword();
        if (CuscStringUtils.isNotEmpty((String)bean.getRequestId())) {
            String secretKey = this.randomIdService.getByRequestId(bean.getRequestId(), bean.getApplicationId());
            if (CuscStringUtils.isEmpty((String)secretKey)) {
                return Response.createError((String)ResponseCode.REQUEST_ID_SECRET_KEY_INVALID.getMsg(), (Integer)ResponseCode.REQUEST_ID_SECRET_KEY_INVALID.getCode());
            }
            this.randomIdService.delRequestIdRedis(bean.getRequestId(), bean.getApplicationId());
            respPwd = Sm4Util.decryptEcbPadding((String)secretKey, (String)respPwd);
        }
        if (!(retUser = this.checkUserByUserName(bean)).isSuccess().booleanValue()) {
            this.checkPwdFailCount(bean, appBean);
            return Response.createError((String)retUser.getMsg(), (Integer)retUser.getCode());
        }
        respPwd = Sm4Util.encryptEcbPadding((String)((UserDTO)retUser.getData()).getUuid().substring(16), (String)respPwd);
        if (!respPwd.equals(((UserDTO)retUser.getData()).getPassword())) {
            this.checkPwdFailCount(bean, appBean);
            return Response.createError((String)ResponseCode.LOGIN_USER_NAME_PASSWORD_INVALID.getMsg(), (Integer)ResponseCode.LOGIN_USER_NAME_PASSWORD_INVALID.getCode());
        }
        EiamUrlDTO urlDTO = new EiamUrlDTO();
        urlDTO.setUserId(((UserDTO)retUser.getData()).getUuid());
        urlDTO.setApplicationId(bean.getApplicationId());
        urlDTO.setTenantNo(bean.getTenantNo());
        this.eiamUrlClient.userRoleResUrlToRedis(((UserDTO)retUser.getData()).getUuid(), bean.getTenantNo(), bean.getApplicationId());
        return this.tokenService.createOauth2TokenByUserName(bean, (UserDTO)retUser.getData());
    }

    public Response<Boolean> sendSmsCaptcha(MobileLoginReq bean) {
        String smsCaptcha;
        Response ret;
        ApplicationDTO appBean = this.appConfigService.getAppConfigByCode(bean.getApplicationId());
        SmsSendConfig smsConfig = bean.getSmsSendConfig();
        this.smsService.convertToSmsConfig(appBean, smsConfig);
        smsConfig.setAppId(bean.getApplicationId());
        smsConfig.setTenantNo(bean.getTenantNo());
        if (bean.isCheckCaptchaImg()) {
            CaptchaVerificationReq cv = new CaptchaVerificationReq();
            cv.setRequestId(bean.getRequestId());
            cv.setCaptchaValue(bean.getCaptchaImage());
            cv.setApplicationId(bean.getApplicationId());
            boolean checkCaptchaImg = this.captchaService.verificationCaptcha(cv);
            if (!checkCaptchaImg) {
                return Response.createError((String)ResponseCode.CAPTCHA_IMAGGE_CHECK_FAIL.getMsg(), (Integer)ResponseCode.CAPTCHA_IMAGGE_CHECK_FAIL.getCode());
            }
        }
        try {
            if (this.cacheFactory.getExpireStringService().containsKey("CT:USER:AUTH:SMS:INTERVAL:CAPTCHA:" + bean.getPhone() + "_" + bean.getTenantNo() + "_" + bean.getApplicationId()).booleanValue()) {
                return Response.createError((String)ResponseCode.SMS_CAPTCHA_INTERVAL_FAIL.getMsg(), (Integer)ResponseCode.SMS_CAPTCHA_INTERVAL_FAIL.getCode());
            }
            smsConfig.setTotalLimitKey("CT:USER:AUTH:SMS:DAY:CAPTCHA:");
            this.smsService.checkSmsSendLimit(bean.getPhone(), smsConfig);
            ret = bean.getUserType() == null || UserTypeEnum.EIAM.getCode() == bean.getUserType().intValue() ? this.checkUserByPhone(bean) : this.checkCiamUserByPhone(bean);
            if (!ret.isSuccess().booleanValue()) {
                return ret;
            }
            smsCaptcha = CuscRandomUtils.randomNumeric((int)6);
            int captchaExpire = 1800;
            if (bean.getCaptchaExpire() != null) {
                captchaExpire = bean.getCaptchaExpire();
            }
            this.cacheFactory.getExpireStringService().setExpireValue("CT:USER:AUTH:SMS:CAPTCHA:" + bean.getPhone() + "_" + bean.getTenantNo() + "_" + bean.getApplicationId(), (Object)smsCaptcha, captchaExpire);
        }
        catch (CacheException e) {
            log.error("sendSmsCaptcha \u5b58\u653ereids\u5931\u8d25\uff1a", (Throwable)e);
            return Response.createError((String)ResponseCode.SMS_CREATE_CAPTCHA_FAIL.getMsg(), (Integer)ResponseCode.SMS_CREATE_CAPTCHA_FAIL.getCode());
        }
        smsConfig.setIntervalLimitKey("CT:USER:AUTH:SMS:INTERVAL:CAPTCHA:");
        ret = this.smsService.sendSms(bean.getPhone(), smsCaptcha, smsConfig);
        if (ret == null) {
            return Response.createError((String)ResponseCode.SMS_CAPTCHA_SEND_FAIL.getMsg(), (Integer)ResponseCode.SMS_CAPTCHA_SEND_FAIL.getCode());
        }
        return Response.createSuccess((Object)true);
    }

    public Response<Boolean> sendSmsCaptchaNew(MobileLoginReq bean) {
        String smsCaptcha;
        ApplicationDTO appBean = this.appConfigService.getAppConfigByCode(bean.getApplicationId());
        SmsSendConfig smsConfig = bean.getSmsSendConfig();
        this.smsService.convertToSmsConfig(appBean, smsConfig);
        smsConfig.setAppId(bean.getApplicationId());
        smsConfig.setTenantNo(bean.getTenantNo());
        if (bean.isCheckCaptchaImg()) {
            CaptchaVerificationReq cv = new CaptchaVerificationReq();
            cv.setRequestId(bean.getRequestId());
            cv.setCaptchaValue(bean.getCaptchaImage());
            cv.setApplicationId(bean.getApplicationId());
            boolean checkCaptchaImg = this.captchaService.verificationCaptcha(cv);
            if (!checkCaptchaImg) {
                return Response.createError((String)ResponseCode.CAPTCHA_IMAGGE_CHECK_FAIL.getMsg(), (Integer)ResponseCode.CAPTCHA_IMAGGE_CHECK_FAIL.getCode());
            }
        }
        try {
            if (this.cacheFactory.getExpireStringService().containsKey("CT:USER:AUTH:SMS:INTERVAL:CAPTCHA:" + bean.getPhone() + "_" + bean.getTenantNo() + "_" + bean.getApplicationId()).booleanValue()) {
                return Response.createError((String)ResponseCode.SMS_CAPTCHA_INTERVAL_FAIL.getMsg(), (Integer)ResponseCode.SMS_CAPTCHA_INTERVAL_FAIL.getCode());
            }
            smsConfig.setTotalLimitKey("CT:USER:AUTH:SMS:DAY:CAPTCHA:");
            this.smsService.checkSmsSendLimit(bean.getPhone(), smsConfig);
            Response ret = bean.getUserType() == null || UserTypeEnum.EIAM.getCode() == bean.getUserType().intValue() ? this.checkUserByPhone(bean) : this.checkCiamUserByPhone(bean);
            if (!ret.isSuccess().booleanValue() && !StringUtils.isEmpty((CharSequence)bean.getLoginType()) && "allow".equals(bean.getLoginType())) {
                ret.setSuccess(Boolean.valueOf(true));
            }
            if (!ret.isSuccess().booleanValue()) {
                return ret;
            }
            smsCaptcha = CuscRandomUtils.randomNumeric((int)6);
            int captchaExpire = 1800;
            if (bean.getCaptchaExpire() != null) {
                captchaExpire = bean.getCaptchaExpire();
            }
            this.cacheFactory.getExpireStringService().setExpireValue("CT:USER:AUTH:SMS:CAPTCHA:" + bean.getPhone() + "_" + bean.getTenantNo() + "_" + bean.getApplicationId(), (Object)smsCaptcha, captchaExpire);
        }
        catch (CacheException e) {
            log.error("sendSmsCaptcha \u5b58\u653ereids\u5931\u8d25\uff1a", (Throwable)e);
            return Response.createError((String)ResponseCode.SMS_CREATE_CAPTCHA_FAIL.getMsg(), (Integer)ResponseCode.SMS_CREATE_CAPTCHA_FAIL.getCode());
        }
        smsConfig.setIntervalLimitKey("CT:USER:AUTH:SMS:INTERVAL:CAPTCHA:");
        this.smsService.sendSms(bean.getPhone(), smsCaptcha, smsConfig);
        return Response.createSuccess((Object)true);
    }

    private Response<UserDTO> checkUserByPhone(MobileLoginReq bean) {
        UserDTO user = new UserDTO();
        user.setPhone(bean.getPhone());
        user.setTenantNo(bean.getTenantNo());
        user.setApplicationId(bean.getApplicationId());
        UserDTO userResp = this.userClient.getUser(user);
        if (userResp == null || CuscStringUtils.isEmpty((String)userResp.getPhone())) {
            return Response.createError((String)ResponseCode.LOGIN_NAME_INVALID.getMsg(), (Integer)ResponseCode.LOGIN_NAME_INVALID.getCode());
        }
        user = userResp;
        if (CommonStatusEnum.ENABLE.getCode() != user.getStatus().intValue()) {
            return Response.createError((String)ResponseCode.LOGIN_NAME_STOP.getMsg(), (Integer)ResponseCode.LOGIN_NAME_STOP.getCode());
        }
        return Response.createSuccess((Object)user);
    }

    private Response<CiamUserDTO> checkCiamUserByPhone(MobileLoginReq bean) {
        CiamUserDTO ciamUser = new CiamUserDTO();
        ciamUser.setPhoneNum(bean.getPhone());
        ciamUser.setTenantNo(bean.getTenantNo());
        CiamUserDTO userResp = this.ciamUserClient.getUserByPhoneTenantNo(ciamUser);
        if (userResp == null || CuscStringUtils.isEmpty((String)userResp.getPhoneNum())) {
            return Response.createError((String)ResponseCode.LOGIN_PHONE_INVALID.getMsg(), (Integer)ResponseCode.LOGIN_PHONE_INVALID.getCode());
        }
        ciamUser = userResp;
        if (CommonStatusEnum.ENABLE.getCode() != ciamUser.getStatus().intValue()) {
            return Response.createError((String)ResponseCode.LOGIN_NAME_STOP.getMsg(), (Integer)ResponseCode.LOGIN_NAME_STOP.getCode());
        }
        return Response.createSuccess((Object)ciamUser);
    }

    private Response<UserDTO> checkUserByUserName(UserNameLoginReq bean) {
        UserDTO user = new UserDTO();
        user.setUserName(bean.getUserName());
        user.setTenantNo(bean.getTenantNo());
        user.setApplicationId(bean.getApplicationId());
        UserDTO userResp = this.userClient.getUser(user);
        if (userResp == null) {
            return Response.createError((String)ResponseCode.LOGIN_NAME_INVALID.getMsg(), (Integer)ResponseCode.LOGIN_NAME_INVALID.getCode());
        }
        user = userResp;
        if (CommonStatusEnum.ENABLE.getCode() != user.getStatus().intValue()) {
            return Response.createError((String)ResponseCode.LOGIN_NAME_STOP.getMsg(), (Integer)ResponseCode.LOGIN_NAME_STOP.getCode());
        }
        return Response.createSuccess((Object)user);
    }

    private void checkPwdFailCount(UserNameLoginReq bean, ApplicationDTO appDTO) {
        if (appDTO.getPwsErrorLockNum() == null || appDTO.getPwsErrorLockNum() <= 0 || appDTO.getPwsErrorLockTerm() == null || appDTO.getPwsErrorLockTerm() <= 0 || appDTO.getPwsErrorLockTime() == null || appDTO.getPwsErrorLockTime() <= 0) {
            return;
        }
        try {
            int expireTime;
            Integer failCount = (Integer)this.cacheFactory.getExpireStringService().getValue("CT:USER:AUTH:USERNAME:PASSWORD_COUNT:" + bean.getUserName() + "_" + bean.getTenantNo() + "_" + bean.getApplicationId(), Integer.class);
            if (failCount == null || failCount == 0) {
                failCount = 1;
                expireTime = appDTO.getPwsErrorLockTerm();
            } else {
                Integer n = failCount;
                Integer n2 = failCount = Integer.valueOf(failCount + 1);
                expireTime = this.cacheFactory.getExpireStringService().getKeyExpireTime("CT:USER:AUTH:USERNAME:PASSWORD_COUNT:" + bean.getUserName() + "_" + bean.getTenantNo() + "_" + bean.getApplicationId()).intValue();
            }
            this.cacheFactory.getExpireStringService().setExpireValue("CT:USER:AUTH:USERNAME:PASSWORD_COUNT:" + bean.getUserName() + "_" + bean.getTenantNo() + "_" + bean.getApplicationId(), (Object)failCount, expireTime);
            if (failCount >= appDTO.getPwsErrorLockNum()) {
                this.cacheFactory.getExpireStringService().setExpireValue("CT:USER:AUTH:USERNAME:LOCK:" + bean.getUserName() + "_" + bean.getTenantNo() + "_" + bean.getApplicationId(), (Object)failCount, appDTO.getPwsErrorLockTime().intValue());
            }
        }
        catch (CacheException e) {
            log.error("\u4fdd\u5b58\u5bc6\u7801\u5931\u8d25\u6b21\u6570\u81f3redis\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private void checkUserNameLock(UserNameLoginReq bean) {
        boolean isLock = false;
        try {
            isLock = this.cacheFactory.getExpireStringService().containsKey("CT:USER:AUTH:USERNAME:LOCK:" + bean.getUserName() + "_" + bean.getTenantNo() + "_" + bean.getApplicationId());
        }
        catch (CacheException e) {
            log.error("\u68c0\u67e5\u5bc6\u7801\u5931\u8d25\u6b21\u6570\u8bbf\u95eeredis\u5f02\u5e38\uff1a", (Throwable)e);
        }
        if (isLock) {
            throw new CuscUserException(ResponseCode.USER_NAME_PWD_FAIL_LOCK.getCode(), ResponseCode.USER_NAME_PWD_FAIL_LOCK.getMsg());
        }
    }
}

