/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.identification.service.impl;

import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaCreateReq;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaCreateResp;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaVerificationReq;
import com.cusc.nirvana.user.auth.identification.service.ICaptchaService;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.wf.captcha.SpecCaptcha;
import java.awt.FontFormatException;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CaptchaServiceImpl
implements ICaptchaService {
    private static final Logger log = LoggerFactory.getLogger(CaptchaServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptchaServiceImpl.class);
    private static final int CAPTCHA_EXPIRE_TIME = 10800;
    @Autowired
    private CacheFactory cacheFactory;

    public CaptchaCreateResp generateCaptcha(CaptchaCreateReq bean) {
        CaptchaCreateResp ret = new CaptchaCreateResp();
        ret.setRequestId(UUID.randomUUID().toString());
        SpecCaptcha captcha = new SpecCaptcha(bean.getCaptchaWidth(), bean.getCaptchaHeight(), bean.getCaptchaLength());
        captcha.setCharType(bean.getCaptchaType().getCode());
        String code = captcha.text().toLowerCase();
        try {
            this.cacheFactory.getExpireStringService().setExpireValue("CT:USER:AUTH:CAPTCHA:IMAGE:" + ret.getRequestId() + "_" + bean.getApplicationId(), (Object)code, 10800);
        }
        catch (CacheException e) {
            log.error("generateCaptcha \u8bf7\u6c42reids\u5931\u8d25 \uff1a", (Throwable)e);
            throw new CuscUserException(ResponseCode.REDIS_OPT_FAIL.getCode() + "", ResponseCode.REDIS_OPT_FAIL.getMsg());
        }
        try {
            captcha.setFont(1);
        }
        catch (IOException e) {
            log.error("generateCaptcha IOException \u8bbe\u7f6e\u5b57\u4f53\u5931\u8d25 \uff1a", (Throwable)e);
        }
        catch (FontFormatException e) {
            log.error("generateCaptcha FontFormatException \u8bbe\u7f6e\u5b57\u4f53\u5931\u8d25 \uff1a", (Throwable)e);
        }
        ret.setCaptchaImg(captcha.toBase64());
        return ret;
    }

    public boolean verificationCaptcha(CaptchaVerificationReq bean) {
        String redisCode;
        try {
            String imageCaptchaKey = "CT:USER:AUTH:CAPTCHA:IMAGE:" + bean.getRequestId() + "_" + bean.getApplicationId();
            redisCode = (String)this.cacheFactory.getExpireStringService().getValue(imageCaptchaKey, String.class);
            this.cacheFactory.getExpireStringService().delete(new String[]{imageCaptchaKey});
        }
        catch (CacheException e) {
            log.error("verificationCaptcha \u8bf7\u6c42reids\u5931\u8d25 \uff1a", (Throwable)e);
            throw new CuscUserException(ResponseCode.REDIS_OPT_FAIL.getCode() + "", ResponseCode.REDIS_OPT_FAIL.getMsg());
        }
        if (bean.getCaptchaValue().toLowerCase().equals(redisCode)) {
            return true;
        }
        log.info("verificationCaptcha false . param requestId:{} , input code:{} , redis code:{} ", new Object[]{bean.getRequestId(), bean.getCaptchaValue(), redisCode});
        return false;
    }
}

