/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.identification.login;

import com.alibaba.fastjson.JSON;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.identification.dto.MobileLoginReq;
import com.cusc.nirvana.user.auth.identification.dto.Oauth2Token;
import com.cusc.nirvana.user.auth.identification.dto.UserNameLoginReq;
import com.cusc.nirvana.user.auth.identification.service.ILoginService;
import com.cusc.nirvana.user.auth.identification.util.CommonParamterCheck;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/login"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    ILoginService loginService;

    @PostMapping(value={"/sendSmsCaptcha"})
    @ApiOperation(value="\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801", notes="\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801")
    public Response<Boolean> sendSmsCaptcha(@RequestBody MobileLoginReq bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getPhone()) || bean.getCaptchaExpire() == null) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        if (bean.isCheckCaptchaImg() && CuscStringUtils.isEmpty((String)bean.getCaptchaImage()) && CuscStringUtils.isEmpty((String)bean.getRequestId())) {
            return Response.createError((String)ResponseCode.CAPTCHA_IMAGGE_NOT_NULL.getMsg(), (Integer)ResponseCode.CAPTCHA_IMAGGE_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)bean.getApplicationId(), (String)bean.getTenantNo());
        log.info("sendSmsCaptcha request url: /user-auth/login/sendSmsCaptcha , param: {}", JSON.toJSON((Object)bean.getPhone()));
        return this.loginService.sendSmsCaptcha(bean);
    }

    @PostMapping(value={"/sendSmsCaptchaNew"})
    @ApiOperation(value="\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801", notes="\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801")
    public Response<Boolean> sendSmsCaptchaNew(@RequestBody MobileLoginReq bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getPhone()) || bean.getCaptchaExpire() == null) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        if (bean.isCheckCaptchaImg() && CuscStringUtils.isEmpty((String)bean.getCaptchaImage()) && CuscStringUtils.isEmpty((String)bean.getRequestId())) {
            return Response.createError((String)ResponseCode.CAPTCHA_IMAGGE_NOT_NULL.getMsg(), (Integer)ResponseCode.CAPTCHA_IMAGGE_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)bean.getApplicationId(), (String)bean.getTenantNo());
        log.info("sendSmsCaptcha request url: /user-auth/login/sendSmsCaptcha , param: {}", JSON.toJSON((Object)bean.getPhone()));
        return this.loginService.sendSmsCaptchaNew(bean);
    }

    @PostMapping(value={"/mobile"})
    @ApiOperation(value="\u624b\u673a\u53f7\u767b\u5f55", notes="\u624b\u673a\u53f7\u767b\u5f55")
    public Response<Oauth2Token> mobileLogin(@RequestBody MobileLoginReq bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getPhone()) || CuscStringUtils.isEmpty((String)bean.getCaptcha())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)bean.getApplicationId(), (String)bean.getTenantNo());
        log.info("mobileLogin request url: /user-auth/login/mobile , phone: {} , captcha: {}", (Object)bean.getPhone(), (Object)bean.getCaptcha().substring(1));
        return this.loginService.mobileLogin(bean);
    }

    @PostMapping(value={"/username"})
    @ApiOperation(value="\u7528\u6237\u540d\u767b\u5f55", notes="\u7528\u6237\u540d\u767b\u5f55")
    public Response<Oauth2Token> userNameLogin(@RequestBody UserNameLoginReq bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getUserName()) || CuscStringUtils.isEmpty((String)bean.getPassword())) {
            return Response.createError((String)ResponseCode.LOGIN_USER_NAME_PASSWORD_INVALID.getMsg(), (Integer)ResponseCode.LOGIN_USER_NAME_PASSWORD_INVALID.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)bean.getApplicationId(), (String)bean.getTenantNo());
        log.info("userNameLogin request url: /user-auth/login/username, param : {}", (Object)JSON.toJSONString((Object)bean));
        return this.loginService.userNameLogin(bean);
    }

    @PostMapping(value={"/userLoginAdd"})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55\u6ce8\u518c", notes="\u7528\u6237\u767b\u5f55\u6ce8\u518c")
    public Response add(@RequestBody MobileLoginReq bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getPhone()) || CuscStringUtils.isEmpty((String)bean.getCaptcha())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)bean.getApplicationId(), (String)bean.getTenantNo());
        log.info("userLoginAdd request url: /user-auth/login/username, param : {}", (Object)JSON.toJSONString((Object)bean));
        return this.loginService.mobileLogin(bean);
    }
}

