/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.authentication.controller;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.authentication.dto.AccessVerifyReq;
import com.cusc.nirvana.user.auth.authentication.service.AccessAuthService;
import com.cusc.nirvana.user.auth.authentication.service.TokenService;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.common.dto.AccessTokenHashDTO;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
public class AccessAuthController {
    private static final Logger log = LoggerFactory.getLogger(AccessAuthController.class);
    @Autowired
    private AccessAuthService accessAuthService;
    @Autowired
    private TokenService tokenService;

    @PostMapping(value={"/getUserByToken"})
    @ApiOperation(value="\u901a\u8fc7token\u83b7\u53d6\u7528\u6237\u4fe1\u606f", notes="\u901a\u8fc7token\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public Response getUserByToken(@RequestBody AccessVerifyReq bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getToken())) {
            return Response.createSuccess();
        }
        return Response.createSuccess((Object)this.accessAuthService.getTokenInfo(bean));
    }

    @PostMapping(value={"/accessVerify"})
    @ApiOperation(value="\u8bf7\u6c42\u9274\u6743", notes="\u8bf7\u6c42\u9274\u6743")
    public Response accessVerify(@RequestBody AccessVerifyReq bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getToken()) || CuscStringUtils.isEmpty((String)bean.getUrl())) {
            return Response.createError((String)ResponseCode.AUTHENTICATION_FAIL.getMsg(), (Integer)ResponseCode.AUTHENTICATION_FAIL.getCode());
        }
        Response ckTokenResp = this.accessAuthService.checkToken(bean);
        if (!ckTokenResp.isSuccess().booleanValue()) {
            return ckTokenResp;
        }
        bean.setAppId(((AccessTokenHashDTO)ckTokenResp.getData()).getAppId());
        bean.setTenantNo(((AccessTokenHashDTO)ckTokenResp.getData()).getTenantNo());
        boolean checkUrl = this.accessAuthService.checkUrlAccess(bean, (AccessTokenHashDTO)ckTokenResp.getData());
        if (!checkUrl) {
            return Response.createError((String)ResponseCode.UNAUTHORIZED.getMsg(), (Integer)ResponseCode.UNAUTHORIZED.getCode());
        }
        this.tokenService.tokenRenewal(ckTokenResp, bean.getToken());
        return ckTokenResp;
    }

    @PostMapping(value={"/isWhiteList"})
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u662f\u767d\u540d\u5355", notes="\u5224\u65ad\u662f\u5426\u662f\u767d\u540d\u5355")
    public Response isWhiteList(@RequestBody AccessVerifyReq bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getServerName()) || CuscStringUtils.isEmpty((String)bean.getUrl())) {
            return Response.createError((String)ResponseCode.WHITE_LIST_AUTHENTICATION_FAIL.getMsg(), (Integer)ResponseCode.WHITE_LIST_AUTHENTICATION_FAIL.getCode());
        }
        return Response.createSuccess((Object)this.accessAuthService.isWhiteList(bean));
    }
}

