package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cache.CacheFactory;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.converter.RoleResourceConverter;
import com.cusc.nirvana.user.eiam.dao.RoleResourceDao;
import com.cusc.nirvana.user.eiam.dao.entity.RoleResourcePO;
import com.cusc.nirvana.user.eiam.dto.RoleDTO;
import com.cusc.nirvana.user.eiam.dto.RoleResourceDTO;
import com.cusc.nirvana.user.eiam.service.IRoleResourceService;
import com.cusc.nirvana.user.eiam.service.IRoleService;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author auto-generator
 * @since 2021-10-20
 */
@Service
@Slf4j
public class RoleResourceServiceImpl extends ServiceImpl<RoleResourceDao, RoleResourcePO>
        implements IRoleResourceService {

    @Autowired
    private CacheFactory cacheFactory;

    @Autowired
    private IRoleService roleService;


    @Override
    @Transactional
    public RoleResourceDTO add(RoleResourceDTO entity) {
        //判断是否存在，存在则返回，不存在则新增
        List<RoleResourceDTO> rrList = queryByList(entity);
        if(!CollectionUtils.isEmpty(rrList)){
            return rrList.get(0);
        }

        entity.setUuid(CuscStringUtils.generateUuid());
        RoleResourcePO rrPO = RoleResourceConverter.INSTANCE.dtoToPo(entity);
        this.save(rrPO);
        return entity;
    }

    @Override
    @Transactional
    public Integer addBatchResource(RoleResourceDTO entity) {
        //检查是否有租户权限和将关联的中间表删除
        deleteByRoleId(entity);
        RoleResourcePO rrDO;
        List<RoleResourcePO> rrList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(entity.getResourceUuidList())) {
            //查询角色信息
            RoleDTO role = new RoleDTO();
            role.setUuid(entity.getRoleId());
            role.setTenantNo(entity.getTenantNo());
            role = roleService.getByUuid(role);
            if (role == null) {
                throw new CuscUserException(ResponseCode.ROLE_INVALID.getCode(), ResponseCode.ROLE_INVALID.getMsg());
            }
            for (String resourceUuid : entity.getResourceUuidList()) {
                rrDO = new RoleResourcePO();
                rrDO.setRoleId(entity.getRoleId());
                rrDO.setResourceId(resourceUuid);
                rrDO.setTenantNo(entity.getTenantNo());
                rrDO.setApplicationId(role.getApplicationId());
                rrDO.setCreator(entity.getCreator());
                rrList.add(rrDO);
            }
            //新增
            this.saveBatch(rrList);
        }
        return rrList.size();
    }

    @Override
    @Transactional
    public boolean deleteByRoleId(RoleResourceDTO bean) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq("role_id", bean.getRoleId());
        updateWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        updateWrapper.eq("tenant_no", bean.getTenantNo());
        updateWrapper.eq(CuscStringUtils.isNotEmpty(bean.getApplicationId()), "application_id",
                bean.getApplicationId());
        RoleResourcePO rrDO = new RoleResourcePO();
        rrDO.setIsDelete(CommonDeleteEnum.DELETED.getCode());
        rrDO.setOperator(bean.getCreator());
        this.update(rrDO, updateWrapper);
        return true;
    }

    @Override
    @Transactional
    public boolean deleteBatchRole(RoleResourceDTO bean) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq("resource_id", bean.getResourceId());
        updateWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        updateWrapper.eq("tenant_no", bean.getTenantNo());
        updateWrapper.eq(CuscStringUtils.isNotEmpty(bean.getApplicationId()), "application_id",
                bean.getApplicationId());
        updateWrapper.in(!CollectionUtils.isEmpty(bean.getRoleIdList()), "role_id", bean.getRoleIdList());

        RoleResourcePO rrPO = new RoleResourcePO();
        rrPO.setIsDelete(CommonDeleteEnum.DELETED.getCode());
        rrPO.setOperator(bean.getOperator());
        this.update(rrPO, updateWrapper);
        return true;
    }

    @Override
    public List<RoleResourceDTO> queryByList(RoleResourceDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc("create_time");

        queryWrapper.eq("tenant_no", bean.getTenantNo());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(bean.getResourceId()), "resource_id", bean.getResourceId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(bean.getRoleId()), "role_id", bean.getRoleId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(bean.getApplicationId()), "application_id", bean.getApplicationId());
        List<RoleResourcePO> record = this.list(queryWrapper);
        return RoleResourceConverter.INSTANCE.poListToDtoList(record);
    }
}
