package com.cusc.nirvana.user.eiam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.dao.entity.UserRolePO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * <p>
 * 用户角色服务类
 * </p>
 *
 * @author yuy336
 * @since 2021-10-20
 */
public interface IUserRoleService extends IService<UserRolePO> {

    /**
     * Description:新增用户角色信息
     * <br />
     * CreateDate 2021-10-29 16:47:08
     *
     * @author yuyi
     **/
    UserRoleDTO add(UserRoleDTO entity);

    /**
     * Description:批量新增用户角色信息
     * <br />
     * CreateDate 2021-10-29 16:47:08
     *
     * @author yuyi
     **/
    Response addBatchRole(UserRoleDTO entity);

    /**
     * Description:通过用户id删除用户角色信息
     * <br />
     * CreateDate 2021-10-29 16:47:08
     *
     * @author yuyi
     **/
    Response deleteByUser(UserRoleDTO entity);

    /**
     * Description:通过角色id删除用户角色信息
     * <br />
     * CreateDate 2021-10-29 16:47:08
     *
     * @author yuyi
     **/
    Response deleteByRole(UserRoleDTO entity);

    /**
     * Description: 通过用户id查询角色集合
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    Map<String, Set<String>> queryRoleListByUserId(String userId, String tenantNo, String appId);

    /**
     * Description:通过角色id删除用户角色信息
     *
     * @param entity 必填：roleId,tenantNo  可选：applicationId
     * @return 删除结果
     * CreateDate 2021-10-29 16:47:08
     * @author yuyi
     **/
    boolean delBatchUser(UserRoleDTO entity);

	/**
	 * 通过用户更新
	 * @param dto
	 */
	void updateByUserId(UserRoleDTO dto);

	/**
	 * 根据userIdList查询列表
	 * @param dto
	 * @return
	 */
	List<UserRoleDTO> queryListByUserIdList(UserRoleDTO dto);

    /**
     * 通过查询条件查询集合数据
     *
     * @param userRole
     * @return 集合对象
     */
    List<UserRoleDTO> queryByList(UserRoleDTO userRole);
}
