package com.cusc.nirvana.user.eiam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.cusc.nirvana.user.eiam.dao.entity.UserResourcePO;
import com.cusc.nirvana.user.eiam.dto.UserResourceDTO;

import java.util.List;

/**
 * 用户资源关系(UserResource)表服务接口
 *
 * @author yuy336
 * @since 2022-01-19 13:41:03
 */
public interface IUserResourceService extends IService<UserResourcePO> {

    
     /**
     * 通过查询条件查询集合数据
     *
     * @param bean
     * @return 集合对象
     */
    List<UserResourceDTO> queryByList(UserResourceDTO bean);

    /**
     * 新增数据
     *
     * @param bean 实例对象
     * @return 实例对象
     */
    UserResourceDTO insert(UserResourceDTO bean);

    /**
     * 批量新增用户资源数据
     *
     * @param bean 实例对象
     * @return 实例对象
     */
    Integer insertBatchResource(UserResourceDTO bean);

    /**
     * 根据用户id删除用户资源信息
     *
     * @param bean 实例对象
     * @return 实例对象
     */
    boolean deleteByUserId(UserResourceDTO bean);
}
