package com.cusc.nirvana.user.eiam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.user.eiam.dao.entity.ResourceTempaltePO;
import com.cusc.nirvana.user.eiam.dto.ResourceTempalteDTO;

import java.util.List;

/**
 * (ResourceTempalte)表服务接口
 *
 * @author yuy336
 * @since 2022-01-11 17:34:45
 */
public interface IResourceTempalteService extends IService<ResourceTempaltePO> {

    /**
     * 通过UUID查询单条数据
     *
     * @param resourceTempalte
     * @return 实例对象
     */
    ResourceTempalteDTO getByUuid(ResourceTempalteDTO resourceTempalte);
    
     /**
     * 通过查询条件查询集合数据
     *
     * @param resourceTempalte
     * @return 集合对象
     */
    List<ResourceTempalteDTO> queryByList(ResourceTempalteDTO resourceTempalte);

    /**
     * 分页查询
     *
     * @param resourceTempalte 筛选条件
     * @return 查询结果
     */
    PageResult<ResourceTempalteDTO> queryByPage(ResourceTempalteDTO resourceTempalte);

    /**
     * 新增数据
     *
     * @param resourceTempalte 实例对象
     * @return 实例对象
     */
    ResourceTempalteDTO insert(ResourceTempalteDTO resourceTempalte);

    /**
     * 修改数据
     *
     * @param resourceTempalte 实例对象
     * @return 实例对象
     */
    ResourceTempalteDTO update(ResourceTempalteDTO resourceTempalte);

    /**
     * 通过主键删除数据
     *
     * @param resourceTempalte
     * @return 是否成功
     */
    boolean deleteById(ResourceTempalteDTO resourceTempalte);

    /**
     * Description: 通过租户编号和应用id查询资源id集合
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    List<String> queryResourceIdList(ResourceTempalteDTO bean);

}
