package com.cusc.nirvana.user.eiam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.user.eiam.dao.entity.OrganizationPO;
import com.cusc.nirvana.user.eiam.dto.OrganizationDTO;
import com.cusc.nirvana.user.eiam.dto.UserOrganDTO;

import java.util.List;

/**
 * 组织机构(Organization)表服务接口
 *
 * @author yuy336
 * @since 2022-01-12 14:59:30
 */
public interface IOrganizationService extends IService<OrganizationPO> {

    /**
     * 通过UUID查询单条数据
     *
     * @param organization
     * @return 实例对象
     */
    OrganizationDTO getByUuid(OrganizationDTO organization);

    /**
     * 通过查询条件查询集合数据
     *
     * @param organization
     * @return 集合对象
     */
    List<OrganizationDTO> queryByList(OrganizationDTO organization);

    /**
     * 分页查询
     *
     * @param organization 筛选条件
     * @return 查询结果
     */
    PageResult<OrganizationDTO> queryByPage(OrganizationDTO organization);

    /**
     * 新增数据
     *
     * @param organization 实例对象
     * @return 实例对象
     */
    OrganizationDTO insert(OrganizationDTO organization);

    /**
     * 修改数据
     *
     * @param organization 实例对象
     * @return 实例对象
     */
    OrganizationDTO update(OrganizationDTO organization);

    /**
     * 通过主键删除数据
     *
     * @param organization
     * @return 是否成功
     */
    boolean deleteById(OrganizationDTO organization);

    /**
     * 冻结数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    boolean frozen(OrganizationDTO bean);

    /**
     * 解冻数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    boolean unfreeze(OrganizationDTO bean);

    /**
     * 通过用户id查询组织集合信息
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    List<OrganizationDTO> getOrganListByUserId(UserOrganDTO bean);
}
