package com.cusc.nirvana.user.eiam.handler;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.exception.CuscUserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * Description: 异常处理
 * <br />
 * CreateDate 2021-11-10 10:00
 *
 * @author yuyi
 **/
@ControllerAdvice
@Order(0)
public class UserEiamExceptionHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(UserEiamExceptionHandler.class);

    @ExceptionHandler(CuscUserException.class)
    @ResponseBody
    @ResponseStatus(HttpStatus.OK)
    public Response<?> cuscUserHandler(CuscUserException e) {
        LOGGER.warn("cuscUserHandler Handler code: {}, msg: {}", e.getCode(), e.getMessage());
        return Response.createError(e.getMessage(), e.getCode());
    }
}
