package com.cusc.nirvana.user.eiam.dao.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.cusc.nirvana.user.eiam.common.BaseIamPO;

/**
 * 用户资源关系(UserResource)实体类
 *
 * @author yuy336
 * @since 2022-01-19 13:41:03
 */
@TableName("eiam_user_resource")
public class UserResourcePO extends BaseIamPO {

    private static final long serialVersionUID = 754874151521959532L;
    
    /**
     * 用户id
     */    
    @TableField("user_id")
    private String userId;
    
    /**
     * 角色id
     */    
    @TableField("resource_id")
    private String resourceId;
    
    /**
     * 租户编号
     */    
    @TableField("tenant_no")
    private String tenantNo;
    
    /**
     * 应用id
     */    
    @TableField("application_id")
    private String applicationId;
    
    /**
     * 最后一次操作人
     */    
    @TableField("operator")
    private String operator;


    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getResourceId() {
        return resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getTenantNo() {
        return tenantNo;
    }

    public void setTenantNo(String tenantNo) {
        this.tenantNo = tenantNo;
    }

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

}

