package com.cusc.nirvana.user.eiam.converter;

import com.cusc.nirvana.user.eiam.dao.entity.UserResourcePO;
import com.cusc.nirvana.user.eiam.dto.UserResourceDTO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 用户资源关系(UserResource)表服务接口
 *
 * @author yuy336
 * @since 2022-01-19 13:41:03
 */
@Mapper
public interface UserResourceConverter {

    UserResourceConverter INSTANCE = Mappers.getMapper(UserResourceConverter.class);

    /**
     * Description: do 转 dto
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    UserResourceDTO poToDto(UserResourcePO bean);

    /**
     * Description: dto 转 do
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    UserResourcePO dtoToPo(UserResourceDTO bean);

    /**
     * Description: do list 转 dto list
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    List<UserResourceDTO> poListToDtoList(List<UserResourcePO> list);
}
